package com.meizu.cloud.pushsdk.handler.impl.notification;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.constants.PushConstants;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.model.PlatformMessage;
import com.meizu.cloud.pushsdk.notification.MPushMessage;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import com.meizu.cloud.pushsdk.util.UxIPUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

/**
 * 处理通知栏点击事件
 * 点击事件传递taskid,供应用使用
 * {"task_id":""}
 */
public class NotificationClickMessageHandler extends AbstractMessageHandler<MessageV3> {

    public NotificationClickMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected MessageV3 getMessage(Intent intent) {
        MessageV3 messageV3 = null;
        try {
            DebugLogger.e(TAG,"parse message V3");
            messageV3 = intent.getParcelableExtra(PushConstants.MZ_PUSH_PRIVATE_MESSAGE);
        } catch (Exception e){
            DebugLogger.e(TAG,"cannot get messageV3");
        } finally {
            if(messageV3 == null){
                DebugLogger.e(TAG,"parse MessageV2 to MessageV3");
                MPushMessage mPushMessage = (MPushMessage) intent.getSerializableExtra(PushConstants.MZ_PUSH_PRIVATE_MESSAGE);
                messageV3 = MessageV3.parse(getPushServiceDefaultPackageName(intent),
                        getDeviceId(intent),
                        mPushMessage.getTaskId(),
                        mPushMessage);
            }
        }
        return messageV3;
    }

    @Override
    protected void unsafeSend(MessageV3 message, PushNotification pushNotification) {
        PushPreferencesUtils.putDiscardNotificationIdByPackageName(context(), message.getPackageName(), 0);
        Intent privateIntent = buildIntent(context(), message);
        if(privateIntent != null){
            privateIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            try {
                context().startActivity(privateIntent);
            } catch (Exception e){
                DebugLogger.e(TAG,"Click message StartActivity error "+e.getMessage());
            }
        }
        //防止从lancher过来的消息回调应用onNotificationClicked方法
        if(!TextUtils.isEmpty(message.getTitle()) && !TextUtils.isEmpty(message.getContent()) && appLogicListener() != null){
            appLogicListener().onNotificationClicked(context(), message.getTitle(), message.getContent(), selfDefineContentString(message.getWebUrl(),message.getParamsMap()));
        }
    }



    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i(TAG, "start NotificationClickMessageHandler match");
        return PushConstants.MZ_PUSH_ON_MESSAGE_ACTION.equals(intent.getAction())
                && PushConstants.MZ_PUSH_MESSAGE_METHOD_ACTION_PRIVATE.equals(getIntentMethod(intent));
    }

    @Override
    public int getProcessorType() {
        return MESSAGE_TYPE_NOTIFICATION_CLICK;
    }


    @Override
    protected void onBeforeEvent(MessageV3 message) {
        UxIPUtils.onClickPushMessageEvent(context(), message.getUploadDataPackageName(), message.getDeviceId(), message.getTaskId(),message.getSeqId(),message.getPushTimestamp());
    }

    /**
     * 创建intent,传递给相应的应用
     * @param context
     * @param messageV3
     * */
    private Intent buildIntent(Context context,MessageV3 messageV3){
        Intent intent = null;
        String openClassName = messageV3.getUriPackageName();
        if(TextUtils.isEmpty(openClassName)){
            openClassName = messageV3.getUploadDataPackageName();
        }
        DebugLogger.i(TAG,"openClassName is "+openClassName);
        if(PushConstants.CLICK_TYPE_LAUNCHER_ACTIVITY == messageV3.getClickType()){
            intent =context.getPackageManager().getLaunchIntentForPackage(openClassName);
            if(intent != null && messageV3.getParamsMap() != null){
                Map<String,String> paramsMap = messageV3.getParamsMap();
                for(Map.Entry<String,String> paramsEntry : paramsMap.entrySet()){
                    DebugLogger.i(TAG, " launcher activity key " + paramsEntry.getKey() + " value " + paramsEntry.getValue());
                    if(!TextUtils.isEmpty(paramsEntry.getKey()) && !TextUtils.isEmpty(paramsEntry.getValue())){
                        String value = paramsEntry.getValue();
                        intent.putExtra(paramsEntry.getKey(),value);
                    }
                }
            }
        } else if(PushConstants.CLICK_TYPE_ACTIVITY == messageV3.getClickType()){
            intent = new Intent();
            //String paramsValue = "";
            if(messageV3.getParamsMap() != null){
                Map<String,String> paramsMap = messageV3.getParamsMap();
                for(Map.Entry<String,String> paramsEntry : paramsMap.entrySet()){
                    DebugLogger.i(TAG," key "+paramsEntry.getKey() + " value "+paramsEntry.getValue());
                    if(!TextUtils.isEmpty(paramsEntry.getKey()) && !TextUtils.isEmpty(paramsEntry.getValue())){
                        String value = paramsEntry.getValue();
                        intent.putExtra(paramsEntry.getKey(),value);
                        //paramsValue += "S."+paramsEntry.getKey() + "=" + value + ";";
                    }
                    //DebugLogger.i(TAG, "paramValue " + paramsValue);
                }
            }
            intent.setClassName(openClassName,messageV3.getActivity());
            DebugLogger.i(TAG,intent.toUri(Intent.URI_INTENT_SCHEME));
//            String intentUri = "intent:#Intent;component="+messageV3.getUploadDataPackageName()+"/"+messageV3.getActivity()+ (TextUtils.isEmpty(paramsValue) ? ";" : ";"+paramsValue)+"end";
//            try {
//                intent = Intent.parseUri(intentUri,Intent.URI_INTENT_SCHEME);
//            } catch (URISyntaxException e) {
//                DebugLogger.e(TAG, "parse Uri error " + e.getMessage());
//            }
        } else if(PushConstants.CLICK_TYPE_WEB == messageV3.getClickType()){
            //url 必须是加上http前缀
            Uri uri = Uri.parse(messageV3.getWebUrl());
            intent  = new Intent(Intent.ACTION_VIEW,uri);
            String uriPackageName = messageV3.getUriPackageName();
            if(!TextUtils.isEmpty(uriPackageName)){
                intent.setPackage(uriPackageName);
                DebugLogger.i(TAG,"set uri package "+uriPackageName);
            }
        } else if(PushConstants.CLICK_TYPE_SELF_DEFINE_ACTION == messageV3.getClickType()){
            DebugLogger.i(TAG,"CLICK_TYPE_SELF_DEFINE_ACTION");
        }
        if(intent != null){
            intent.putExtra(PushConstants.MZ_PUSH_PLATFROM_EXTRA,
                    PlatformMessage.builder()
                            .taskId(messageV3.getTaskId())
                            .build()
                            .toJson());
        }
        return intent;
    }

}
