package com.meizu.cloud.pushsdk.handler.impl.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.meizu.cloud.pushinternal.DebugLogger;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by liaojinlong on 17-3-20.
 *
 * {
     //最大上传文件大小，单位KB
     "max_size": 1024,
     //将要上传的文件(夹)
     "upload_files": [
     "sdcard/Android/data/com.meizu.pushdemo",
     "sdcard/Android/data/com.meizu.mzstore",
     "sdcard/Android/data/pushsdk/logs_v2.txt"
     ],
     //是否仅wifi上传
     "wifi_upload": true,
    }

 */
public class UploadLogMessage implements Parcelable{
    private static final String TAG = "UploadLogMessage";
    private int maxSize;
    private boolean wifiUpload;
    private List<String> fileList;
    private ControlMessage controlMessage;
    private String uploadMessage;

    public static final String MAX_SIZE = "max_size";
    public static final String UPLOAD_FILES ="upload_files";
    public static final String WIFI_UPLOAD = "wifi_upload";

    public UploadLogMessage(String uploadMessage,String control,String deviceId, String seqId) {
        this.uploadMessage = uploadMessage;
        try {
            JSONObject jsonObject = new JSONObject(uploadMessage);
            if(!jsonObject.isNull(MAX_SIZE)){
                this.maxSize = jsonObject.getInt(MAX_SIZE);
            }
            if(!jsonObject.isNull(WIFI_UPLOAD)){
                this.wifiUpload = jsonObject.getBoolean(WIFI_UPLOAD);
            }
            if(!jsonObject.isNull(UPLOAD_FILES)){
                JSONArray jsonArray = jsonObject.getJSONArray(UPLOAD_FILES);
                this.fileList = new ArrayList<>();
                for(int i=0 ; i< jsonArray.length() ; i++){
                    fileList.add(jsonArray.getString(i));
                }
            }
        } catch (JSONException e) {
            DebugLogger.e(TAG,"parse upload message error "+e.getMessage());
        }
        this.controlMessage = new ControlMessage(control,deviceId,seqId);
    }

    protected UploadLogMessage(Parcel in) {
        maxSize = in.readInt();
        wifiUpload = in.readByte() != 0;
        fileList = in.createStringArrayList();
        controlMessage = in.readParcelable(ControlMessage.class.getClassLoader());
        uploadMessage = in.readString();
    }

    public static final Creator<UploadLogMessage> CREATOR = new Creator<UploadLogMessage>() {
        @Override
        public UploadLogMessage createFromParcel(Parcel in) {
            return new UploadLogMessage(in);
        }

        @Override
        public UploadLogMessage[] newArray(int size) {
            return new UploadLogMessage[size];
        }
    };

    public int getMaxSize() {
        return maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public boolean isWifiUpload() {
        return wifiUpload;
    }

    public void setWifiUpload(boolean wifiUpload) {
        this.wifiUpload = wifiUpload;
    }

    public List<String> getFileList() {
        return fileList;
    }

    public void setFileList(List<String> fileList) {
        this.fileList = fileList;
    }

    public ControlMessage getControlMessage() {
        return controlMessage;
    }

    public void setControlMessage(ControlMessage controlMessage) {
        this.controlMessage = controlMessage;
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(maxSize);
        parcel.writeByte((byte) (wifiUpload ? 1 : 0));
        parcel.writeStringList(fileList);
        parcel.writeParcelable(controlMessage, i);
        parcel.writeString(uploadMessage);
    }

    @Override
    public String toString() {
        return "UploadLogMessage{" +
                "maxSize=" + maxSize +
                ", wifiUpload=" + wifiUpload +
                ", fileList=" + fileList +
                ", controlMessage=" + controlMessage +
                ", uploadMessage='" + uploadMessage + '\'' +
                '}';
    }
}
