package com.meizu.cloud.pushsdk.handler.impl.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.meizu.cloud.pushinternal.DebugLogger;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by liaojinlong on 17-3-20.
 */
public class Statics implements Parcelable{
    public static final String TAG = "statics";
    private String taskId;
    private String time;
    private boolean pushExtra = false;
    private String deviceId;
    private String seqId;

    public static final String TASK_ID = "taskId";
    public static final String TIME = "time";
    public static final String PUSH_EXTRA = "pushExtra";

    public Statics(){
        super();
    }


    protected Statics(Parcel in) {
        taskId = in.readString();
        time = in.readString();
        pushExtra = in.readByte() != 0;
        deviceId = in.readString();
        seqId = in.readString();
    }

    public static final Creator<Statics> CREATOR = new Creator<Statics>() {
        @Override
        public Statics createFromParcel(Parcel in) {
            return new Statics(in);
        }

        @Override
        public Statics[] newArray(int size) {
            return new Statics[size];
        }
    };

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public boolean getPushExtra() {
        return pushExtra;
    }

    public void setPushExtra(boolean pushExtra) {
        this.pushExtra = pushExtra;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getSeqId() {
        return seqId;
    }

    public void setSeqId(String seqId) {
        this.seqId = seqId;
    }



    public static Statics parse(JSONObject staticsObj){
        Statics statics = new Statics();
        if(staticsObj != null){
            try {
                if(!staticsObj.isNull(TASK_ID)){
                    statics.setTaskId(staticsObj.getString(TASK_ID));
                }
                if(!staticsObj.isNull(TIME)){
                    statics.setTime(staticsObj.getString(TIME));
                }
                if(!staticsObj.isNull(PUSH_EXTRA)){
                    statics.setPushExtra(staticsObj.getInt(PUSH_EXTRA) == 0 ? false : true);
                }
            } catch (JSONException e){
                DebugLogger.e(TAG," parse statics message error "+e.getMessage());
            }
        } else {
            DebugLogger.e(TAG,"no control statics can parse ");
        }
        return statics;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(taskId);
        parcel.writeString(time);
        parcel.writeByte((byte) (pushExtra ? 1 : 0));
        parcel.writeString(deviceId);
        parcel.writeString(seqId);
    }

    @Override
    public String toString() {
        return "Statics{" +
                "taskId='" + taskId + '\'' +
                ", time='" + time + '\'' +
                ", pushExtra=" + pushExtra +
                ", deviceId='" + deviceId + '\'' +
                ", seqId='" + seqId + '\'' +
                '}';
    }
}
