package com.meizu.cloud.pushsdk.handler.impl.model;

import android.text.TextUtils;

import com.meizu.cloud.pushsdk.pushtracer.dataload.TrackerDataload;

/**
 * Created by liaojinlong on 17-4-27.
 * 用于传递平台参数信息
 */
public class PlatformMessage {
    public static final String PLATFORM_TASK_ID = "task_id";
    public static final String PLATFORM_SEQ_ID = "seq_id";
    public static final String PLATFORM_PUSH_TIMESTAMP = "push_timestamp";
    public static final String PLATFORM_DEVICE_ID = "device_id";
    String taskId;
    String seqId;
    String pushTimesTamp;
    String deviceId;

    public static class Builder{
        private String taskId;
        private String seqId;
        private String pushTimesTamp;
        private String deviceId;

        /**
         * @param taskId
         * @return itself
         * */
        public Builder taskId(String taskId){
            this.taskId = taskId;
            return this;
        }

        /**
         * @param seqId
         * @return  itself
         * */
        public Builder seqId(String seqId){
            this.seqId = seqId;
            return this;
        }

        /**
         * @param pushTimesTamp
         * @return itself
         * */
        public Builder pushTimesTamp(String pushTimesTamp){
            this.pushTimesTamp = pushTimesTamp;
            return this;
        }

        /**
         * @param deviceId
         * @return itself
         * */
        public Builder deviceId(String deviceId){
            this.deviceId = deviceId;
            return this;
        }

        public PlatformMessage build(){
            return new PlatformMessage(this);
        }
    }

    public PlatformMessage(Builder builder){
        this.taskId = (!TextUtils.isEmpty(builder.taskId) ? builder.taskId : "");
        this.seqId = (!TextUtils.isEmpty(builder.seqId) ? builder.seqId : "");
        this.pushTimesTamp = (!TextUtils.isEmpty(builder.pushTimesTamp) ? builder.pushTimesTamp : "");
        this.deviceId = (!TextUtils.isEmpty(builder.deviceId) ? builder.deviceId : "");

    }

    public static Builder builder(){
        return new Builder();
    }


    public String toJson(){
        TrackerDataload trackerDataload = new TrackerDataload();
        trackerDataload.add(PLATFORM_TASK_ID,this.taskId);
        trackerDataload.add(PLATFORM_SEQ_ID,this.seqId);
        trackerDataload.add(PLATFORM_PUSH_TIMESTAMP,this.pushTimesTamp);
        trackerDataload.add(PLATFORM_DEVICE_ID,this.deviceId);
        return trackerDataload.toString();
    }
}
