package com.meizu.cloud.pushsdk.handler.impl.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.meizu.cloud.pushsdk.handler.MessageV3;

/**
 * Created by liaojinlong on 17-3-17.
 */
public class NotificationState implements Parcelable{

    public static final int STATE_NOTIFICATION_SHOW_ACCESS_DENY = -2;
    public static final int STATE_NOTIFICATION_SHOW_INBOX = -1;
    public static final int STATE_NOTIFICATION_SHOW_NORMAL = 0;
    public static final int STATE_NOTIFICATION_SHOW_FLOAT = 1;

    private MessageV3 messageV3;
    private String notificationPkg;
    private int notificationId;
    private int state;

    public NotificationState(MessageV3 messageV3) {
        this.messageV3 = messageV3;
    }

    protected NotificationState(Parcel in) {
        messageV3 = in.readParcelable(MessageV3.class.getClassLoader());
        notificationPkg = in.readString();
        notificationId = in.readInt();
        state = in.readInt();
    }

    public static final Creator<NotificationState> CREATOR = new Creator<NotificationState>() {
        @Override
        public NotificationState createFromParcel(Parcel in) {
            return new NotificationState(in);
        }

        @Override
        public NotificationState[] newArray(int size) {
            return new NotificationState[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeParcelable(messageV3, i);
        parcel.writeString(notificationPkg);
        parcel.writeInt(notificationId);
        parcel.writeInt(state);
    }


    public MessageV3 getMessageV3() {
        return messageV3;
    }

    public void setMessageV3(MessageV3 messageV3) {
        this.messageV3 = messageV3;
    }

    public String getNotificationPkg() {
        return notificationPkg;
    }

    public void setNotificationPkg(String notificationPkg) {
        this.notificationPkg = notificationPkg;
    }

    public int getNotificationId() {
        return notificationId;
    }

    public void setNotificationId(int notificationId) {
        this.notificationId = notificationId;
    }

    public int getState() {
        return state;
    }

    public void setState(int state) {
        this.state = state;
    }

    @Override
    public String toString() {
        return "NotificationState{" +
                "messageV3=" + messageV3 +
                ", notificationPkg='" + notificationPkg + '\'' +
                ", notificationId='" + notificationId + '\'' +
                ", state='" + state + '\'' +
                '}';
    }
}
