package com.meizu.cloud.pushsdk.handler.impl.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by liaojinlong on 17-3-17.
 *
 * {
     "ctl": {
             "pushType": 0, //0:通知栏消息； 1: 透传消息 2: 上报日志指令
             "cached": 0,    //0:不缓存消息； 1: 缓存通知栏消息
             "cacheNum":10  //通知栏消息最大缓存数量
            },
     "statics": {
             "taskId": "41159",   // 任务taskID
             "time": "1475118843"  // 任务创建时间
             "pushExtra":0 //是否上报push extra 信息 , 0 不上报,1 上报,如果没有该字段默认上报
         }
 *  }
 */
public class ControlMessage implements Parcelable{
    public static final String TAG = "ControlMessage";
    private String controlMessage;
    private Control control;
    private Statics statics;

    public ControlMessage(){
        super();
    }

    public ControlMessage(String controlMessage,String deviceId, String seqId) {
        this.controlMessage = controlMessage;
        if(!TextUtils.isEmpty(controlMessage)){
            try {
                JSONObject controlObj = new JSONObject(controlMessage);
                if(controlObj !=  null){
                    control = Control.parse(controlObj.getJSONObject(Control.TAG));
                    statics = Statics.parse(controlObj.getJSONObject(Statics.TAG));
                    statics.setDeviceId(deviceId);
                    statics.setSeqId(seqId);
                }
            } catch (JSONException e) {
                control = new Control();
                statics = new Statics();
                DebugLogger.e(TAG,"parse control message error "+e.getMessage());
            }
        } else {
            control = new Control();
            statics = new Statics();
        }


    }

    protected ControlMessage(Parcel in) {
        controlMessage = in.readString();
        control = in.readParcelable(Control.class.getClassLoader());
        statics = in.readParcelable(Statics.class.getClassLoader());
    }

    public static final Creator<ControlMessage> CREATOR = new Creator<ControlMessage>() {
        @Override
        public ControlMessage createFromParcel(Parcel in) {
            return new ControlMessage(in);
        }

        @Override
        public ControlMessage[] newArray(int size) {
            return new ControlMessage[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(controlMessage);
        parcel.writeParcelable(control, i);
        parcel.writeParcelable(statics, i);
    }

    public String getControlMessage() {
        return controlMessage;
    }

    public void setControlMessage(String controlMessage) {
        this.controlMessage = controlMessage;
    }

    public Control getControl() {
        return control;
    }

    public void setControl(Control control) {
        this.control = control;
    }

    public Statics getStatics() {
        return statics;
    }

    public void setStatics(Statics statics) {
        this.statics = statics;
    }


    public static ControlMessage parse(String control){
        ControlMessage controlMessage = new ControlMessage();
        try {
            JSONObject controlObj = new JSONObject(control);
            if(controlObj !=  null){
                controlMessage.setControl(Control.parse(controlObj.getJSONObject(Control.TAG)));
                controlMessage.setStatics(Statics.parse(controlObj.getJSONObject(Statics.TAG)));
            }
        } catch (Exception e) {
            DebugLogger.e(TAG,"parse control message error "+e.getMessage());
            controlMessage.setStatics(new Statics());
            controlMessage.setControl(new Control());
        }
        return controlMessage;
    }

    @Override
    public String toString() {
        return "ControlMessage{" +
                "controlMessage='" + controlMessage + '\'' +
                ", control=" + control +
                ", statics=" + statics +
                '}';
    }
}
