package com.meizu.cloud.pushsdk.handler.impl.fileupload;


import android.os.Environment;

import com.meizu.cloud.pushinternal.DebugLogger;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * zip utils
 */
public class ZipTask {
    private static final String TAG = "ZipTask";
    private static final int BUFF_SIZE = 1024 * 1024; // 1M Byte
    private static final int M_SIZE = 1024;

    /**压缩的log文件地址**/
    private File zipFile;

    public ZipTask(String zipFilepath){
        this.zipFile = new File(zipFilepath);
    }

    public boolean zip(String... resFile){
        boolean isZipSuccess = true;
        try {
            if(!zipFile.exists()){
                zipFile.getParentFile().mkdirs();
            }
            List<File> resFileList = new ArrayList<>();
            String root = Environment.getExternalStorageDirectory().getAbsolutePath();
            for (String filePath : resFile){
                File file = new File(root + filePath);
                if(file.exists()){
                    resFileList.add(file);
                }
            }
            zipFiles(resFileList,zipFile);
        } catch (Exception e) {
            isZipSuccess = false;
            e.printStackTrace();
            DebugLogger.e(TAG, "zip file error " + e.getMessage());
        }

        return isZipSuccess;
    }

    public boolean zip(List<String> listfile) throws Exception{
        if(!zipFile.exists()){
            zipFile.getParentFile().mkdirs();
        }
        List<File> resFileList = new ArrayList<>();
        String root = Environment.getExternalStorageDirectory().getAbsolutePath();
        for (String filePath : listfile){
            File file = new File(root+filePath);
            if(file.exists()){
                resFileList.add(file);
            }
        }
        zipFiles(resFileList,zipFile);
        return true;
    }

    /**
     * 批量压缩文件（夹）
     *
     * @param resFileList 要压缩的文件（夹）列表
     * @param zipFile 生成的压缩文件
     */
    private void zipFiles(Collection<File> resFileList, File zipFile) throws Exception{
        ZipOutputStream zipout;
        zipout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(
                zipFile), BUFF_SIZE));
        for (File resFile : resFileList) {
            zipFile(resFile, zipout, "");
        }
        zipout.close();
    }

    /**
     * 批量压缩文件（夹）
     *
     * @param resFileList 要压缩的文件（夹）列表
     * @param zipFile 生成的压缩文件
     * @param comment 压缩文件的注释
     */
    private void zipFiles(Collection<File> resFileList, File zipFile, String comment) throws Exception{
        ZipOutputStream zipout = null;
        zipout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), BUFF_SIZE));
        for (File resFile : resFileList) {
            zipFile(resFile, zipout, "");
        }
        zipout.setComment(comment);
        zipout.close();
    }

    /**
     * 压缩文件
     *
     * @param resFile 需要压缩的文件（夹）
     * @param zipout 压缩的目的文件
     * @param rootpath 压缩的文件路径
     */
    private void zipFile(File resFile, ZipOutputStream zipout, String rootpath) throws Exception{
        rootpath = rootpath + (rootpath.trim().length() == 0 ? "" : File.separator) + resFile.getName();
        if (resFile.isDirectory()) {
            File[] fileList = resFile.listFiles();
            int length=fileList.length;
            for (int i=0;i<length;i++) {
                File file=fileList[i];
                zipFile(file, zipout, rootpath);
            }
        } else {
            DebugLogger.i(TAG,"current file "+rootpath+"/"+resFile.getName()+" size is "+resFile.length()/M_SIZE +"KB");
            if(resFile.length() < 10 * M_SIZE * M_SIZE){
                byte buffer[] = new byte[BUFF_SIZE];
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(resFile),
                        BUFF_SIZE);
                zipout.putNextEntry(new ZipEntry(rootpath));
                int realLength;
                while ((realLength = in.read(buffer)) != -1) {
                    zipout.write(buffer, 0, realLength);
                }
                in.close();
                zipout.flush();
                zipout.closeEntry();
            }
        }
    }

}
