package com.meizu.cloud.pushsdk.handler.impl.fileupload;

import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.constants.PushConstants;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.model.ControlMessage;
import com.meizu.cloud.pushsdk.handler.impl.model.UploadLogMessage;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.platform.api.PushPlatformManager;
import com.meizu.cloud.pushsdk.util.Connectivity;
import com.meizu.cloud.pushsdk.util.UxIPUtils;

import java.io.File;

/**
 * Created by liaojinlong on 17-3-17.
 */
public class LogUploadMessageHandler extends AbstractMessageHandler<UploadLogMessage> {
    public LogUploadMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected UploadLogMessage getMessage(Intent intent) {
        String control = intent.getStringExtra(PushConstants.MZ_PUSH_CONTROL_MESSAGE);
        String seqId = intent.getStringExtra(PushConstants.EXTRA_APP_PUSH_SEQ_ID);
        String deviceId = intent.getStringExtra(PushConstants.MZ_PUSH_MESSAGE_STATISTICS_IMEI_KEY);
        String pushMessage = intent.getStringExtra(PushConstants.MZ_PUSH_PRIVATE_MESSAGE);
        UploadLogMessage uploadLogMessage = new UploadLogMessage(pushMessage,control,deviceId,seqId);
        return uploadLogMessage;
    }

    @Override
    protected void unsafeSend(UploadLogMessage message, PushNotification pushNotification) {
        DebugLogger.flush();
        //获取log文件
        String root = Environment.getExternalStorageDirectory().getAbsolutePath();
        String messageId = message.getControlMessage().getStatics().getTaskId();
        String deviceId = message.getControlMessage().getStatics().getDeviceId();
        String uploadFile = root+"/Android/data/pushSdktmp/"+messageId+"_"+deviceId+".zip";
        ZipTask zipTask = new ZipTask(uploadFile);
        String errorMessage = null;
        File zipFile = null;
        try {
            zipTask.zip(message.getFileList());
            zipFile = new File(uploadFile);
        } catch (Exception e){
            errorMessage = e.getMessage();
            zipFile = null;
            DebugLogger.e(TAG,"zip error message "+errorMessage);
        }
        if(zipFile != null && zipFile.length()/1024 > message.getMaxSize()){
            errorMessage = "the upload file exceeds the max size";
        } else if(message.isWifiUpload()&& !Connectivity.isConnectedWifi(context())){
            errorMessage = "current network not allowed upload log file";
        }
        ANResponse<String> response = PushPlatformManager.getInstance(context())
                .uploadLogFile(message.getControlMessage().getStatics().getTaskId(),
                        message.getControlMessage().getStatics().getDeviceId(),
                        errorMessage,
                        zipFile);
        if(response != null && response.isSuccess()){
            if(zipFile != null){
                zipFile.delete();
            }
            DebugLogger.e(TAG, "upload success " + response.getResult());
        } else {
            DebugLogger.i(TAG,"upload error code "+response.getError()+response.getResult());
        }

    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i(TAG, "start LogUploadMessageHandler match");
        String control = intent.getStringExtra(PushConstants.MZ_PUSH_CONTROL_MESSAGE);
        int pushType = 0;
        if(!TextUtils.isEmpty(control)){
            ControlMessage controlMessage = ControlMessage.parse(control);
            if(controlMessage.getControl() != null){
                pushType = controlMessage.getControl().getPushType();
            }
        }
        return PushConstants.MZ_PUSH_ON_MESSAGE_ACTION.equals(intent.getAction()) &&
                PushConstants.PUSH_TYPE_UPLOAD_LOG.equals(String.valueOf(pushType));
    }

    @Override
    public int getProcessorType() {
        return MESSAGE_TYPE_UPLOAD_FILE_LOG;
    }

    @Override
    protected void onBeforeEvent(UploadLogMessage message) {
        UxIPUtils.onReceivePushMessageEvent(context(),
                context().getPackageName(),
                message.getControlMessage().getStatics().getDeviceId(),
                message.getControlMessage().getStatics().getTaskId(),
                message.getControlMessage().getStatics().getSeqId(),
                message.getControlMessage().getStatics().getTime());
    }
}
