package com.meizu.cloud.pushsdk.handler.impl;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.constants.PushConstants;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;

/**
 * 处理反注册消息
 */
public class UnRegisterMessageHandler extends AbstractMessageHandler<Boolean> {
    public UnRegisterMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected Boolean getMessage(Intent intent) {
        //5.0 反注册回调
        boolean isSuccess = intent.getBooleanExtra(PushConstants.EXTRA_APP_IS_UNREGISTER_SUCCESS,false);
        //4.0 反注册错误回调
        String error = intent.getStringExtra(PushConstants.EXTRA_REGISTRATION_ERROR);
        //3.0 反注册回调
        String removed = intent.getStringExtra(PushConstants.EXTRA_UNREGISTERED);
        DebugLogger.i(TAG, "processUnRegisterCallback 5.0:" + isSuccess + " 4.0:" + error + " 3.0:" + removed);
        if(TextUtils.isEmpty(error) || isSuccess || !TextUtils.isEmpty(removed)) {
            /*SharedPreferences preferences = context().getSharedPreferences(PushConstants.PUSH_ID_PREFERENCE_NAME, Context.MODE_PRIVATE);
            preferences.edit().putString(PushConstants.KEY_PUSH_ID,"").commit();*/
            PushPreferencesUtils.putPushId(context(),"",context().getPackageName());
            return true;
        } else {
            return false;
        }
    }

    @Override
    protected void unsafeSend(Boolean message, PushNotification pushNotification) {
        if(appLogicListener() != null){
            appLogicListener().onUnRegister(context(),message);
        }
    }


    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i(TAG, "start UnRegisterMessageHandler match");
        return PushConstants.MZ_PUSH_ON_UNREGISTER_ACTION.equals(intent.getAction())
                 || (PushConstants.REQUEST_UNREGISTRATION_INTENT.equals(intent.getAction())
                 && TextUtils.isEmpty(intent.getStringExtra(PushConstants.EXTRA_UNREGISTERED)));
    }

    @Override
    public int getProcessorType() {
        return MESSAGE_TYPE_UNREGISTER;
    }
}
