package com.meizu.cloud.pushsdk.handler.impl;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.constants.PushConstants;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;

/**
 * 注册请求消息
 */
public class RegisterMessageHandler extends AbstractMessageHandler<String> {
    public RegisterMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected String getMessage(Intent intent) {
        String pushId = intent.getStringExtra(PushConstants.EXTRA_APP_PUSH_ID);
        PushPreferencesUtils.putPushId(context(),pushId,context().getPackageName());
        PushPreferencesUtils.putPushIdExpireTime(context(),0,context().getPackageName());
        return pushId;
    }

    @Override
    protected void unsafeSend(String message, PushNotification pushNotification) {
        if (appLogicListener() != null){
            appLogicListener().onRegister(context(),message);
        }
    }



    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i(TAG, "start RegisterMessageHandler match");
        return PushConstants.MZ_PUSH_ON_REGISTER_ACTION.equals(intent.getAction())
                || (PushConstants.REGISTRATION_CALLBACK_INTENT.equals(intent.getAction())
                    && !TextUtils.isEmpty(intent.getStringExtra(PushConstants.EXTRA_REGISTRATION_ID)));
    }

    @Override
    public int getProcessorType() {
        return MESSAGE_TYPE_REGISTER;
    }
}
