package com.meizu.cloud.pushsdk.constants;

/**
 * Created by liaojinlong on 15-4-8.
 *
 * Push 相关常量
 *
 */
public interface PushConstants {

    /**
     * 魅族推送服务配置action,用于绑定启动pushService
     * */
    public static final String MZ_PUSH_SERVICE_ACTION = "com.meizu.cloud.pushservice.action.PUSH_SERVICE";

//------------------------------------------------以下为MzPushReceiver接受消息的配置参数-----------------------------------------------------------------start

    /* 订阅接口发送消息的Receiver Action */
    public static final String MZ_PUSH_ON_REGISTER_ACTION = "com.meizu.flyme.push.intent.REGISTER.FEEDBACK";
    /* 取消订阅发送消息的Receiver Action */
    public static final String MZ_PUSH_ON_UNREGISTER_ACTION = "com.meizu.flyme.push.intent.UNREGISTER.FEEDBACK";
    /* 接受push消息的Receiver Action */
    public static final String MZ_PUSH_ON_MESSAGE_ACTION = "com.meizu.flyme.push.intent.MESSAGE";

    /**以下是相关参数定义-5.0*/
    /* pushId 参数字段 */
    public static final String EXTRA_APP_PUSH_ID        = "registration_id";
    /* 接受message参数字段 */
    public static final String EXTRA_APP_PUSH_MESSAGE   = "message";
    /* 反注册成功与否参数字段 */
    public static final String EXTRA_APP_IS_UNREGISTER_SUCCESS = "extra_app_is_unregister_success";

    /**
     * 兼容5.0以下版本配置
     * */
    public static final String EXTRA_PUSH_MESSAGE = "message";
    public static final String EXTRA_REGISTRATION_ID = "registration_id";
    public static final String EXTRA_REGISTRATION_ERROR = "registration_error";


//-----------------------------------------------MzPushReceiver接受消息的配置参数-------------------------------------------------------------------------end


//-----------------------------------------------以下为MzPushService处理应用订阅与反订阅消息配置参数--------------------------------------------------------start
    /**发起获取应用通知栏消息action*/
    public static final String MZ_PUSH_ON_GET_NOTIFICATION_MESSAGE = "com.meizu.flyme.push.intent.GET_NOTIFICATION_MESSAGE";
    public static final String EXTRA_GET_NOTIFICATION_PACKAGE_NAME = "extra_notification_package_name";
    /* 向pushService发起订阅请求action */
    public static final String MZ_PUSH_ON_START_PUSH_REGISTER = "com.meizu.flyme.push.intent.REGISTER";
    /* 向pushService发起反订阅请求Action */
    public static final String MZ_PUSH_ON_STOP_PUSH_REGISTER = "com.meizu.flyme.push.intent.UNREGISTER";

    /**flyme 3.0 兼容**/
    //flyme 3.0 订阅action
    public static final String REQUEST_REGISTRATION_INTENT = "com.meizu.c2dm.intent.REGISTER";
    //flyme 3.0 反订阅aciton
    public static final String REQUEST_UNREGISTRATION_INTENT = "com.meizu.c2dm.intent.UNREGISTER";
    //flyme 3.0 向C2DM服务器注册后的回调处理
    public static final String REGISTRATION_CALLBACK_INTENT = "com.meizu.c2dm.intent.REGISTRATION";
    //flyme 3.0 接收到C2DM服务器的推送消息
    public static final String C2DM_INTENT = "com.meizu.c2dm.intent.RECEIVE";
    public static final String EXTRA_APPLICATION_PENDING_INTENT = "app";
    // 向C2DM反注册返回的intent中包含的key
    public static final String EXTRA_UNREGISTERED = "unregistered";

     /**
     * 以下是参数配置说明-5.0
     * */
    /* 业务注册pushId传递包名Key */
    public static final String REGISTER_PACKAGE_NAME    = "sender";
    /* 业务反注册pushId传递包名Key */
    public static final String UNREGISTER_PACKAGE_NAME    = "sender";

    /**
     * 兼容5.0以下版本，注册与反注册获取应用包名
     * */
    public static final String EXTRA_SENDER = "sender";

    /**
     * 管理对应包名的应用的通知权限
     * */
    String EXTRA_ORIGINAL_NOTIFICATION_PACKAGE_NAME = "android.originalPackageName";

    /** key: the json settings for push notifications
     */
    String EXTRA_FLYME_GREEN_NOTIFICATION_SETTING = "android.flymeNotificationSetting";

    /**
     * 通知栏携带参数
     * */
    String NOTIFICATION_EXTRA_TASK_ID = "notification_extra_task_id";
    String NOTIFICATION_EXTRA_SEQ_ID = "notification_extra_seq_id";
    String NOTIFICATION_EXTRA_DEVICE_ID = "notification_extra_device_id";
    String NOTIFICATION_EXTRA_PUSH_TIMESTAMP = "notification_extra_push_timestamp";
    String NOTIFICATION_EXTRA_SHOW_PACKAGE_NAME = "notification_extra_show_package_name";
//-----------------------------------------------MzPushService处理应用订阅与反订阅消息配置参数------------------------------------------------end


    public static final String PUSH_ID_PREFERENCE_NAME = "com.meizu.flyme.push";
    public static final String KEY_PUSH_ID = "pushId";
    public static final String KEY_PUSH_ID_EXPIRE_TIME = "pushId_expire_time";

//----------------------------------------------push开关相关参数----------------------------------------------------------------------------
    public static final String SWITCH_NOTIFICATION_MESSAGE = "switch_notification_message";
    public static final String SWITCH_THROUGH_MESSAGE = "switch_through_message";
    public static final String MZ_PUSH_ON_MESSAGE_SWITCH_SETTING = "com.meizu.flyme.push.intent.MESSAGE_SWITCH";
    public static final String EXTRA_APP_PUSH_SWITCH_SETTING_TYPE = "extra_app_push_switch_setting_type";
    public static final String EXTRA_APP_PUSH_SWITCH_SETTING_PACKAGE_NAME = "extra_app_push_switch_package_name";
    public static final String EXTRA_APP_PUSH_SWITCH_SETTING_STATUS = "extra_app_push_switch_setting_status";

    public static final String PUSH_ALIAS = "push_alias";
//-----------------------------------------------以下是内部pushReceiver配置的参数------------------------------------------------------------start


    /* 标记消息的属性，是否为私有，或者透传消息*/
    public static final String MZ_PUSH_MESSAGE_METHOD = "method";
    // method 常量预定义
    public static final String MZ_PUSH_MESSAGE_METHOD_ACTION_PRIVATE = "private";
    public static final String MZ_PUSH_MESSAGE_METHOD_ACTION_NOTIFICATION_SHOW = "notification_show";
    public static final String MZ_PUSH_MESSAGE_METHOD_ACTION_NOTIFICATION_DELETE = "notification_delete";
    public static final String MZ_PUSH_MESSAGE_METHOD_ACTION_NOTIFICATION_STATE = "notification_state";
    public static final String MZ_PUSH_MESSAGE_METHOD_ACTION_PUSH_STATUS = "push_status";
    public static final String MZ_PUSH_MESSAGE_METHOD_ACTION_REGISTER_STATUS = "register_status";
    public static final String MZ_PUSH_MESSAGE_METHOD_ACTION_UNREGISTER_STATUS = "un_register_status";
    public static final String MZ_PUSH_MESSAGE_METHOD_ACTION_SUBTAGS_STATUS = "sub_tags_status";
    public static final String MZ_PUSH_MESSAGE_METHOD_ACTION_SUBALIAS_STATUS = "sub_alias_status";
    public static final String MZ_PUSH_MESSAGE_METHOD_ACTION_SCHEDULE_NOTIFICATION = "schedule_notification";
    public static final String MZ_PUSH_MESSAGE_METHOD_ACTION_RESPONSE_NOTIFICATION_MESSAGE = "response_notification_message";

    /**method for through message*/
    public static final String MZ_PUSH_MESSAGE_METHOD_ACTION_MESSAGE = "message";
    /**method for notification_v3 message**/
    public static final String MZ_PUSH_MESSAGE_METHOD_ACTION_NOTIFICATION_SHOW_V3 = "notification_show_v3";
    /**method for upload log file**/
    public static final String MZ_PUSH_MESSAGE_METHOD_ACTION_UPLOAD_LOG_FILE = "upload_log_file";
    /* 数据统计需要的imei*/
    public static final String MZ_PUSH_MESSAGE_STATISTICS_IMEI_KEY = "statistics_imei_key";
    /* 内部消息传递key值*/
    String MZ_PUSH_PRIVATE_MESSAGE = "pushMessage";
    /**push  平台传递的control字段*/
    String MZ_PUSH_CONTROL_MESSAGE = "mz_push_control_message";
    /**notification state model key**/
    String MZ_PUSH_NOTIFICATION_STATE_MESSAGE = "notification_state_message";

    /**点击消息platform extra key**/
    String MZ_PUSH_PLATFROM_EXTRA = "platform_extra";
//------------------------------------------------内部pushReceiver配置的参数-------------------------------------------------------------------end

//-------------------------------------------------内部参数配置---------------------------------------------------------------------------------------------start
    /* push消息的taskId */
    public static final String EXTRA_APP_PUSH_SEQ_ID = "extra_app_push_seq_Id";
    public static final String EXTRA_APP_PUSH_TASK_ID   = "extra_app_push_task_Id";
    public static final String EXTRA_APP_PUSH_SWITCH_STATUS = "extra_app_push_switch_status";
    public static final String EXTRA_APP_PUSH_REGISTER_STATUS = "extra_app_push_register_status";
    public static final String EXTRA_APP_PUSH_UNREGISTER_STATUS = "extra_app_push_un_register_status";
    public static final String EXTRA_APP_PUSH_SUBTAGS_STATUS = "extra_app_push_sub_tags_status";
    public static final String EXTRA_APP_PUSH_SUBALIAS_STATUS = "extra_app_push_sub_alias_status";
    public static final String EXTRA_APP_PUSH_SCHEDULE_NOTIFICATION_MESSAGE = "extra_app_push_schedule_notification_message";
    public static final String EXTRA_APP_PUSH_SERVICE_DEFAULT_PACKAGE_NAME = "extra_app_push_service_default_package_name";
    public static final String EXTRA_APP_PUSH_TASK_TIMES_TAMP = "extra_app_push_task_timestamp";
    public static final String EXTRA_APP_PUSH_RESPONSE_NOTIFICATION_MESSAGE = "extra_app_push_response_notification_message";
//-------------------------------------------------内部参数配置---------------------------------------------------------------------------------------------end

    String MZ_PUSH_NOTIFICATION_SMALL_ICON = "mz_push_notification_small_icon";




//-------------------------------------------------push消息格式字段预定义------------------------------------------------------------------------------------start

     /**
      * 任务ID
      * */
     public static final String TASK_ID = "task_id";

     /**
      * push消息类型：透传，预定义通知消息
      * **/
     public static final String PUSH_TYPE = "push_type";

     /**
      * 标题
      * */
     public static final String TITLE = "title";

     /**
      * 通知栏内容
      * **/
     public static final String CONTENT = "content";

    /**
     * 重复消息忽略
     * */
     public static final String IS_DISCARD = "isDiscard";

     /**
      * 通知提示类型
      * */
     public static final String NOTIFY_TYPE = "notify_type";

     /**
      * 点击通知栏效果
      * */
     public static final String CLICK_TYPE = "clickType";

     /**
      * 可选参数
      * */
     public static final String EXTRA = "extra";

     /**
      * 附带参数
      * */
     public static final String PARAMS = "parameters";

     /**
      * 跳转页面的名称
      * */
     public static final String INTENT_ACTIVITY_NAME = "activity";

     /**
      * web_uri地址
      * */
     public static final String WEB_URL = "url";

     /**
      * uri package name
      * */
     public static final String URI_PACKAGE_NAME = "pk";

     /**
      * push notification create timestamp for task usagestats
      * */
     public static final String PUSH_NOTIFICATION_CREATE_TIMES_TAMP = "tt";




    /**
     * 常量预定义
     * */
    String PUSH_TYPE_NOTIFY = "0";
    String PUSH_TYPE_THROUGH_MESSAGE = "1";
    String PUSH_TYPE_UPLOAD_LOG = "2";

    public static final int CLICK_TYPE_LAUNCHER_ACTIVITY = 0;

    public static final int CLICK_TYPE_ACTIVITY = 1;

    public static final int CLICK_TYPE_WEB = 2;

    public static final int CLICK_TYPE_SELF_DEFINE_ACTION = 3;

//---------------------------------------------------------push消息格式字段预定义---------------------------------------------------------------------------end


    //----------------------pushInfo message type---------------------------------------------------------------------------------------------------------
    /**pushService send message by NotificationService**/
    public static final int PUSHSERVICE_INFO_SENDMESSAGE_BY_NOTIFICATIONSERVICE = 1000;
    /**pushService send message by broadCast*/
    public static final int PUSHSERVICE_INFO_SENDMESSAGE_BY_BROADCAST = 1001;
    /**pushService send message By NotificationService error sendBroadcast**/
    public static final int PUSHSERVICE_INFO_SENDMESSAGE_BY_NOTIFICATIONSERVICE_ERROR = 1002;


    /**pushSDk start service send message*/
    public static final int NOTIFICATIONSERVICE_SEND_MESSAGE = 2003;
    /**pushSDK start notification service send message error*/
    public static final int NOTIFICATIONSERVICE_SEND_MESSAGE_ERROR = 2004;
    /**pushSDK start notification service error so send broadcast*/
    public static final int NOTIFICATIONSERVICE_SEND_MESSAGE_BROADCAST = 2005;

    public static final int BROADCAST_MESSAGE_ARRIVE = 2100;

    /**expire notification**/
    public static final int EXPIRE_NOTIFICATION = 2200;
    public static final int ONTIME_NOTIFICATION = 2201;
    public static final int DELAY_NOTIFICATION = 2202;

    public static final int WORK_RECEIVER_EVENTCORE_ERROR = 3000;

    /**down load largeicon pic error*/
    public static final int DOWN_LOAD_LARGE_ICON_ERROR = 2300;
    /**down load largeIcon pic success**/
    public static final int DOWN_LOAD_LARGE_ICON_SUCCESS = 2301;

 }
