package com.meizu.cloud.pushsdk.base.reflect;


import com.meizu.cloud.pushsdk.base.Logger;

import java.lang.reflect.Field;

/**
 * Created by zbin on 17-2-16.
 */

public class ReflectField {
    private String TAG = "ReflectField";
    private ReflectClass mReflectClass;
    private String mFieldName;

    ReflectField(ReflectClass reflectClass, String fieldName) {
        mReflectClass = reflectClass;
        mFieldName = fieldName;
    }

    private Field getField() throws ClassNotFoundException, NoSuchFieldException {
        Field field = mReflectClass.getRealClass().getDeclaredField(mFieldName);
        field.setAccessible(true);
        return field;
    }

    /**
     * 设置静态/非静态成员变量的值
     * @param receiver 待设置成员的对象
     * @param <T> 成员的类型
     * @return 反射调用的结果
     */
    public <T> ReflectResult<T> set(Object receiver, T value) {
        ReflectResult<T> result = new ReflectResult<>();
        try {
            Field field = getField();
            field.set(receiver, value);
            result.value = value;
            result.ok = true;
        } catch (Exception e) {
            Logger.get().e(TAG, "set", e);
        }
        return result;
    }

    /**
     * 设置静态成员变量的值
     * @param <T> 静态成员变量的类型
     * @return 反射调用的结果
     */
    public <T> ReflectResult<T> setStatic(T value) {
        try {
            return set(mReflectClass.getRealClass(), value);
        } catch (Exception e) {
            Logger.get().e(TAG, "setStatic", e);
        }
        return new ReflectResult<>();
    }

    /**
     * 获取静态/非静态成员变量的值
     * @param receiver 待获取成员的对象
     * @param <T> 成员的类型
     * @return 反射调用的结果
     */
    public <T> ReflectResult<T> get(Object receiver) {
        ReflectResult<T> result = new ReflectResult<>();
        try {
            Field field = getField();
            result.value = (T) field.get(receiver);
            result.ok = true;
        } catch (Exception e) {
            Logger.get().e(TAG, "get", e);
        }
        return result;
    }

    /**
     * 获取静态成员变量的值
     * @param <T> 静态成员变量的类型
     * @return 反射调用的结果
     */
    public <T> ReflectResult<T> getStatic() {
        try {
            return get(mReflectClass.getRealClass());
        } catch (Exception e) {
            Logger.get().e(TAG, "getStatic", e);
        }
        return new ReflectResult<>();
    }
}
