package com.meizu.cloud.pushsdk.base.reflect;


import com.meizu.cloud.pushsdk.base.Logger;

import java.lang.reflect.Constructor;

/**
 * Created by zbin on 17-2-16.
 */

public class ReflectConstructor {
    private String TAG = "ReflectConstructor";
    private ReflectClass mReflectClass;
    private Class<?>[] mTypes;

    ReflectConstructor(ReflectClass reflectClass, Class<?>... types) {
        mReflectClass = reflectClass;
        mTypes = types;
    }

    public <T> ReflectResult<T> newInstance(Object... args) {
        ReflectResult<T> result = new ReflectResult<>();
        try {
            Constructor<?> constructor = mReflectClass.getRealClass().getDeclaredConstructor(mTypes);
            constructor.setAccessible(true);
            result.value = (T) constructor.newInstance(args);
            result.ok = true;
        } catch (Exception e) {
            Logger.get().e(TAG, "newInstance", e);
        }
        return result;
    }
}
