package com.meizu.cloud.pushsdk.base.reflect;

import java.util.HashMap;

/**
 * Created by zbin on 17-2-16.
 */

public class ReflectClass {
    private static HashMap<String, Class<?>> mCachedClasses = new HashMap<>();
    private Class<?> mClass;
    private String mClassName;
    private Object mClassObject;

    private ReflectClass(String name) {
        mClassName = name;
    }

    private ReflectClass(Object object) {
        mClassObject = object;
    }

    public ReflectClass(Class<?> clz) {
        mClass = clz;
    }

    Class<?> getRealClass() throws ClassNotFoundException {
        Class<?> clz;
        if(mClass != null) {
            clz = mClass;
        } else if(mClassObject != null) {
            clz = mClassObject.getClass();
        } else {
            clz = mCachedClasses.get(mClassName);
            if(clz == null) {
                clz = Class.forName(mClassName);
                mCachedClasses.put(mClassName, clz);
            }
        }
        return clz;
    }

    /**
     * 通过类名获取ReflectClass对象
     * @param className 要反射的类的全限定名
     * @return 返回ReflectClass对象
     */
    public static ReflectClass forName(String className) {
        return new ReflectClass(className);
    }

    /**
     * 通过对象获取ReflectClass对象
     * @param classObject 要反射的对象
     * @return 返回ReflectClass对象
     */
    public static ReflectClass forObject(Object classObject) {
        return new ReflectClass(classObject);
    }

    /**
     * 通过要反射方法的名字与方法签名来获取ReflectMethod对象
     * @param methodName 要反射的方法名
     * @param types 要反射的方法的参数签名
     * @return 返回ReflectMethod对象
     */
    public ReflectMethod method(String methodName, Class<?>... types) {
        return new ReflectMethod(this, methodName, types);
    }

    /**
     * 通过要反射的成员的名字来获取ReflectField对象
     * @param fieldName 要反射的成员变量的名字
     * @return 返回ReflectField对象
     */
    public ReflectField field(String fieldName) {
        return new ReflectField(this, fieldName);
    }

    /**
     * 通过构造函数方法参数签名获取ReflectConstructor对象
     * @param types 构造函数的方法签名
     * @return 返回ReflectConstructor对象
     */
    public ReflectConstructor constructor(Class<?>... types) {
        return new ReflectConstructor(this, types);
    }
}
