package com.meizu.cloud.pushsdk.base;

/**
 * Created by zbin on 16-11-25.
 */
public class Proxy<T> {
    protected T mOuterImpl, mInnerImpl;

    protected Proxy(T innerImpl) {
        if(innerImpl == null) {
            throw new RuntimeException("proxy must be has a default implementation");
        }
        mInnerImpl = innerImpl;
    }

    public void setImpl(T impl) {
        mOuterImpl = impl;
    }

    protected T getImpl() {
        if(mOuterImpl != null) {
            return mOuterImpl;
        }
        return mInnerImpl;
    }
}
