package com.meizu.cloud.pushsdk.base;

import android.content.Context;
import android.telephony.TelephonyManager;
import com.meizu.cloud.pushsdk.base.reflect.ReflectClass;
import com.meizu.cloud.pushsdk.base.reflect.ReflectResult;

/**
 * Created by zbin on 17-2-16.
 */

public class MzTelephoneManager {
    private final static String CLASS_NAME = "android.telephony.MzTelephonyManager";
    private final static String METHOD_NAME = "getDeviceId";

    public static String getDeviceId(Context context) {
        String deviceId;
        ReflectResult<String> result = ReflectClass.forName(CLASS_NAME)
                .method(METHOD_NAME)
                .invokeStatic();
        if(result.ok) {
            deviceId = result.value;
        } else {
            TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            deviceId = tm.getDeviceId();
        }
        return deviceId;
    }
}
