package com.meizu.cloud.pushsdk.base;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Environment;

/**
 * Created by zbin on 17-2-16.
 */

public class Logger extends Proxy<ICacheLog> implements ICacheLog {
    private static Logger sInstance;
    private boolean mInitialized = false;

    protected Logger(ICacheLog innerImpl) {
        super(innerImpl);
    }

    public static Logger get() {
        if(sInstance == null) {
            synchronized (Logger.class) {
                if(sInstance == null) {
                    sInstance = new Logger(new DefaultLog());
                }
            }
        }
        return sInstance;
    }

    /**
     * 初始化
     * 1. 设置默认路径/sdcard/Android/data/pkgName
     * @param context app上下午
     */
    public void init(Context context) {
        if(!mInitialized) {
            mInitialized = true;
            if((context.getApplicationInfo().flags & ApplicationInfo.FLAG_DEBUGGABLE) != 0) {
                setDebugMode(true);
            } else {
                setDebugMode(false);
            }
            setFilePath(Environment.getExternalStorageDirectory().getAbsolutePath() +
                    "/Android/data/pushSdk/" + context.getPackageName());
        }
    }

    @Override
    public void d(String tag, String msg) {
        getImpl().d(tag, msg);
    }

    @Override
    public void i(String tag, String msg) {
        getImpl().i(tag, msg);
    }

    @Override
    public void w(String tag, String msg) {
        getImpl().w(tag, msg);
    }

    @Override
    public void e(String tag, String msg) {
        getImpl().e(tag, msg);
    }

    @Override
    public void e(String tag, String msg, Throwable tr) {
        getImpl().e(tag, msg, tr);
    }

    @Override
    public void setCacheDuration(long seconds) {
        getImpl().setCacheDuration(seconds);
    }

    @Override
    public void setCacheCount(int counter) {
        getImpl().setCacheCount(counter);
    }

    @Override
    public void setFilePath(String path) {
        getImpl().setFilePath(path);
    }

    @Override
    public void flush(boolean async) {
        getImpl().flush(async);
    }

    @Override
    public void setDebugMode(boolean debug) {
        getImpl().setDebugMode(debug);
    }

    @Override
    public boolean isDebugMode() {
        return getImpl().isDebugMode();
    }

}
