package com.meizu.cloud.pushsdk.base;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.*;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by zbin on 16-12-6.
 */
public abstract class IntentReceiver extends BroadcastReceiver {
    private static HandlerThread sHandlerThread;
    private static Handler sHandler;
    private static AtomicInteger sAtomicInteger;

    static {
        sAtomicInteger = new AtomicInteger(0);
    }

    @Override
    public void onReceive(final Context context, final Intent intent) {
        if(sAtomicInteger.getAndIncrement() == 0) {
            sHandlerThread = new HandlerThread("IntentReceiver", android.os.Process.THREAD_PRIORITY_BACKGROUND);
            sHandlerThread.start();
            sHandler = new Handler(sHandlerThread.getLooper());
        }
        sHandler.post(new Runnable() {
            @Override
            public void run() {
                onHandleIntent(context, intent);
                if(sAtomicInteger.decrementAndGet() == 0) {
                    sHandlerThread.quit();
                }
            }
        });
    }

    protected abstract void onHandleIntent(Context context, Intent intent);
}
