package com.meizu.cloud.pushsdk.base;

/**
 * Created by zbin on 17-2-16.
 */

public interface ICacheLog {
    void d(String tag, String msg);
    void i(String tag, String msg);
    void w(String tag, String msg);
    void e(String tag, String msg);
    void e(String tag, String msg, Throwable tr);

    /**
     * 设置缓存的间隔
     * @param seconds 每隔seconds秒调用flush一次
     */
    void setCacheDuration(long seconds);

    /**
     * 设置缓存的最大日志条目数
     * @param counter 当缓存日志条目数达到counter时调用flush
     */
    void setCacheCount(int counter);

    /**
     * 设置日志文件的路径，默认为：
     * Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/pkgName/
     * @param path 日志保存的路径
     */
    void setFilePath(String path);

    /**
     * 清空缓存
     * @param async 是否异步执行
     */
    void flush(boolean async);

    /**
     * 设置debug模式，debug模式下，日志会即时输出到控制台
     * @param debug true debug模式，否则非debug模式
     */
    void setDebugMode(boolean debug);

    /**
     * 是否为debug模式
     * @return true debug模式，否则非debug模式
     */
    boolean isDebugMode();
}
