package com.meizu.cloud.pushsdk.base;

import android.util.Log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

/**
 * Created by zbin on 17-2-16.
 */

class EncryptionWriter implements ILogWriter {
    private String TAG = "EncryptionWriter";
    private SimpleDateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private EncryptBase64 mEncryptBase64;
    private BufferedWriter mWriter;
    private int mFileCount = 7;
    private String mFileSuffixName = ".log.txt";

    public EncryptionWriter() {
        mEncryptBase64 = new EncryptBase64("lo");
    }

    void checkFileCount(File dir) {
        File[] files = dir.listFiles(new FileFilter() {
            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(mFileSuffixName);
            }
        });
        if(files != null || files.length > mFileCount) {
            Arrays.sort(files, new ComparatorByLastModified());
            for(int i = mFileCount; i < files.length; ++i) {
                files[i].delete();
            }
        }
    }

    @Override
    public void open(String path) throws IOException {
        File dir = new File(path);
        if(!dir.exists()) {
            if(!dir.mkdirs()) {
                throw new IOException("create " + path + " dir failed!!!");
            }
        }
        String name = mDateFormat.format(new Date());
        File file = new File(path, name + mFileSuffixName);
        if(!file.exists()) {
            if(!file.createNewFile()) {
                Log.e(TAG, "create new file " + name + " failed !!!");
            } else {
                checkFileCount(dir);
            }
        }
        mWriter = new BufferedWriter(new FileWriter(file, true));
    }

    @Override
    public void write(String header, String tag, String msg) throws IOException {
        if(mWriter != null) {
            StringBuffer buffer = new StringBuffer(header);
            buffer.append(tag);
            buffer.append(" ");
            buffer.append(msg);
            mWriter.write(mEncryptBase64.encode(buffer.toString().getBytes()));
            mWriter.write("\r\n");
        }
    }

    @Override
    public void close() throws IOException {
        if(mWriter != null) {
            mWriter.flush();
            mWriter.close();
            mWriter = null;
        }
    }

    /**
     * 降序比较器
     */
    class ComparatorByLastModified implements Comparator<File> {

        public int compare(File f1, File f2) {
            long diff = f1.lastModified() - f2.lastModified();
            if (diff > 0) {
                return -1;
            } else if (diff == 0) {
                return 0;
            } else {
                return 1;
            }
        }
    }
}
