package com.meizu.cloud.pushsdk;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Process;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.base.reflect.ReflectClass;
import com.meizu.cloud.pushsdk.base.reflect.ReflectResult;
import com.meizu.cloud.pushsdk.constants.PushConstants;
import com.meizu.cloud.pushsdk.handler.impl.model.ControlMessage;
import com.meizu.cloud.pushsdk.pushtracer.QuickTracker;
import com.meizu.cloud.pushsdk.util.UxIPUtils;
import java.util.List;

/**
 * Created by liaojinlong on 15-6-16.
 */
public class NotificationService extends IntentService {
    private final static String TAG = "NotificationService";

    private Object newInstance;

    public NotificationService(String name) {
        super(name);
    }

    public NotificationService(){
        super(TAG);
    }

    @Override
    public void onDestroy() {
        DebugLogger.i(TAG, "NotificationService destroy");
        newInstance = null;
        super.onDestroy();
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        android.os.Process.setThreadPriority(Process.THREAD_PRIORITY_BACKGROUND);
        try {
            if(intent != null){
                DebugLogger.i(TAG, "onHandleIntentaction " + intent.getAction());
                String commandType = intent.getStringExtra("command_type");
                DebugLogger.d(TAG, "-- command_type -- " + commandType);
                if(!TextUtils.isEmpty(commandType) && commandType.equals("reflect_receiver")) {
                    String controlMessage = intent.getStringExtra(PushConstants.MZ_PUSH_CONTROL_MESSAGE);
                    DebugLogger.i(TAG,"control message is "+controlMessage);
                    //init push tracker
                    if(!TextUtils.isEmpty(controlMessage)){
                        ControlMessage message = new ControlMessage(controlMessage,null,null);
                        QuickTracker.init(this,message.getStatics().getPushExtra());
                    }
                    this.reflectReceiver(intent);
                }
            }
        } catch (Exception e){
            DebugLogger.e(TAG,"onHandleIntent error "+e.getMessage());
        }


    }

    @Override
    public boolean onUnbind(Intent intent) {
        return super.onUnbind(intent);
    }

    public String getReceiver(String var1, String var2) {
        if(!TextUtils.isEmpty(var1) && !TextUtils.isEmpty(var2)) {
            String var3 = null;
            List var4;
            Intent var5 = new Intent(var2);
            var5.setPackage(var1);
            PackageManager var6 = this.getPackageManager();
            var4 = var6.queryBroadcastReceivers(var5, 0);
            if(var4 != null && var4.size() > 0) {
                var3 = ((ResolveInfo)var4.get(0)).activityInfo.name;
            }
            return var3;
        } else {
            return null;
        }
    }

    public void reflectReceiver(Intent intent) {
        String receiver = this.getReceiver(this.getPackageName(), intent.getAction());
        if(TextUtils.isEmpty(receiver)) {
            UxIPUtils.notificationEvent(this,intent,"reflectReceiver sendbroadcast",PushConstants.NOTIFICATIONSERVICE_SEND_MESSAGE_BROADCAST);
            DebugLogger.i("NotificationService", " reflectReceiver error: receiver for: " + intent.getAction() + " not found, package: " + this.getPackageName());
            intent.setPackage(this.getPackageName());
            this.sendBroadcast(intent);
        } else {
            try {
                UxIPUtils.notificationEvent(this, intent, "reflectReceiver startservice", PushConstants.NOTIFICATIONSERVICE_SEND_MESSAGE);

                /*Class receiverClass = Class.forName(receiver);
                Constructor receiverClassConstructor = receiverClass.getConstructor((Class[])null);
                Object newInstance = receiverClassConstructor.newInstance((Object[])null);
                Class[] var7 = new Class[]{Context.class, Intent.class};
                Method onReceive = receiverClass.getMethod("onReceive", var7);
                intent.setClassName(this.getPackageName(), receiver);
                Object[] params = new Object[]{this.getApplicationContext(), intent};
                onReceive.invoke(newInstance, params);*/

                intent.setClassName(this.getPackageName(), receiver);
                ReflectResult<Object> receiverResult = ReflectClass.forName(receiver).constructor((Class[]) null).newInstance((Object[])null);
                if(receiverResult.ok && receiverResult.value != null){
                    DebugLogger.i("NotificationService","Reflect MzPushReceiver "+receiverResult.ok);
                    ReflectClass.forObject(receiverResult.value)
                            .method("onReceive",new Class[]{Context.class, Intent.class})
                            .invoke(receiverResult.value,new Object[]{this.getApplicationContext(), intent});
                }
            } catch (Exception var11) {
                DebugLogger.i("NotificationService", "reflect e: " + var11);
                UxIPUtils.notificationEvent(this,intent,var11.getMessage(),PushConstants.NOTIFICATIONSERVICE_SEND_MESSAGE_ERROR);
            }

        }
    }


}
