package com.meizu.cloud.pushsdk;

import android.content.Context;
import android.content.Intent;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.base.IntentReceiver;
import com.meizu.cloud.pushsdk.constants.PushConstants;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;
import com.meizu.cloud.pushsdk.util.UxIPUtils;


/**
 * Created by liaojinlong on 15-4-8.
 */
public abstract class MzPushMessageReceiver extends IntentReceiver {

    public static final String TAG = "MzPushMessageReceiver";

    @Override
    public void onReceive(final Context context, final Intent intent) {
        try {
            super.onReceive(context,intent);
        } catch (Exception e){
            DebugLogger.e(TAG,"Event core error "+e.getMessage());
            UxIPUtils.onRecordMessageFlow(context, context.getPackageName(), null, null, PushManager.TAG, TAG+" "+e.getMessage(), PushConstants.WORK_RECEIVER_EVENTCORE_ERROR);
        }
    }

    @Override
    public void onHandleIntent(Context context, Intent intent) {
        PushMessageProxy.with(context)
                .receiverListener(TAG,new AbstractAppLogicListener() {
                    @Override
                    public void onRegister(Context context, String pushId) {
                        DebugLogger.i(TAG, "onRegister " + pushId);
                        MzPushMessageReceiver.this.onRegister(context,pushId);
                    }

                    @Override
                    public void onMessage(Context context, String message) {
                        MzPushMessageReceiver.this.onMessage(context,message);
                        DebugLogger.i(TAG,"receive message "+message);
                    }

                    @Override
                    public void onMessage(Context context, String message, String platformExtra) {
                        MzPushMessageReceiver.this.onMessage(context,message,platformExtra);
                        DebugLogger.i(TAG,"receive message "+message+" platformExtra "+platformExtra);
                    }

                    @Override
                    public void onUnRegister(Context context, boolean success) {
                        DebugLogger.i(TAG, "onUnRegister " + success);
                        MzPushMessageReceiver.this.onUnRegister(context,success);
                    }

                    @Override
                    public void onMessage(Context context, Intent intent) {
                        DebugLogger.i(TAG, "onMessage Flyme3 " + intent);
                        MzPushMessageReceiver.this.onMessage(context,intent);
                    }

                    @Override
                    public void onUpdateNotificationBuilder(PushNotificationBuilder pushNotificationBuilder) {
                        MzPushMessageReceiver.this.onUpdateNotificationBuilder(pushNotificationBuilder);
                    }

                    @Override
                    public void onPushStatus(Context context,PushSwitchStatus pushSwitchStatus) {
                        DebugLogger.i(TAG,"onPushStatus "+pushSwitchStatus);
                        MzPushMessageReceiver.this.onPushStatus(context,pushSwitchStatus);
                    }

                    @Override
                    public void onRegisterStatus(Context context,RegisterStatus registerStatus) {
                        DebugLogger.i(TAG,"onRegisterStatus "+registerStatus);
                        MzPushMessageReceiver.this.onRegisterStatus(context,registerStatus);
                    }

                    @Override
                    public void onUnRegisterStatus(Context context,UnRegisterStatus unRegisterStatus) {
                        DebugLogger.i(TAG,"onUnRegisterStatus "+unRegisterStatus);
                        MzPushMessageReceiver.this.onUnRegisterStatus(context,unRegisterStatus);
                    }

                    @Override
                    public void onSubTagsStatus(Context context,SubTagsStatus subTagsStatus) {
                        DebugLogger.i(TAG,"onSubTagsStatus "+subTagsStatus);
                        MzPushMessageReceiver.this.onSubTagsStatus(context,subTagsStatus);
                    }

                    @Override
                    public void onSubAliasStatus(Context context,SubAliasStatus subAliasStatus) {
                        DebugLogger.i(TAG,"onSubAliasStatus "+subAliasStatus);
                        MzPushMessageReceiver.this.onSubAliasStatus(context,subAliasStatus);
                    }

                    @Override
                    public void onNotificationClicked(Context context, String title, String content, String selfDefineContentString) {
                        DebugLogger.i(TAG,"onNotificationClicked title "+title + "content "+content + " selfDefineContentString "+selfDefineContentString);
                        MzPushMessageReceiver.this.onNotificationClicked(context,title,content,selfDefineContentString);
                    }

                    @Override
                    public void onNotificationArrived(Context context, String title, String content, String selfDefineContentString) {
                        DebugLogger.i(TAG,"onNotificationArrived title "+title + "content "+content + " selfDefineContentString "+selfDefineContentString);
                        MzPushMessageReceiver.this.onNotificationArrived(context,title,content,selfDefineContentString);
                    }

                    @Override
                    public void onNotificationDeleted(Context context, String title, String content, String selfDefineContentString) {
                        DebugLogger.i(TAG,"onNotificationDeleted title "+title + "content "+content + " selfDefineContentString "+selfDefineContentString);
                        MzPushMessageReceiver.this.onNotificationDeleted(context,title,content,selfDefineContentString);
                    }

                    @Override
                    public void onNotifyMessageArrived(Context context, String message) {
                        DebugLogger.i(TAG,"onNotifyMessageArrived "+message);
                        MzPushMessageReceiver.this.onNotifyMessageArrived(context,message);
                    }
                }).processMessage(intent);
    }

    /**
     * 通过调用pushManager后，发起push请求，此过程是异步的，如果成功，就会回调onBind
     * @param context
     *            context
     * @param pushId
     *            绑定成功后服务端返回的pushId
     * */
    @Deprecated
    public abstract void onRegister(Context context,String pushId);

    /**
     * 收到透传推送消息的回调,Flyme4.0以上版本,或者云服务5.0以上版本 通过此方法接收Push消息
     * @param context
     *            context
     * @param message
     *            收到的推送消息
     * */
    public void onMessage(Context context,String message){};

    /**
     * 收到透传推送消息的回调,与上面的方法两者只需要实现一个就行了
     *
     * @param context
     *            context
     * @param message
     *            收到的透传推送消息
     * @param platformExtra Flyme5 以下版本,taskId为空,注意判空
     *            平台相关参数,目前传递的任务id,格式如下:
     *            {"task_id":"1232","seq_id":"123","push_timestamp":"","device_id":""}
     * */
    public void onMessage(Context context,String message,String platformExtra){};

    /**
     * 处理flyme3.0平台的推送消息
     * @param context
     * @param intent
     *           flyme3.0平台上默认是将透传的消息json,按照key-value的组合设置到intent中,如果要获取相应的数据,可以调用intent.getExtra(key)方法获取
     * */
    public void onMessage(Context context,Intent intent){}
     /**
     * 收到反注册消息回调
     * */
    @Deprecated
    public abstract void onUnRegister(Context context,boolean success);

    /**
     * 获取smallicon
     * */
    public void onUpdateNotificationBuilder(PushNotificationBuilder pushNotificationBuilder){

    };


    /**
     * 接收通知点击的函数
     * @param context
     * @param title
     *           通知标题
     * @param content
     *           通知内容
     * @param selfDefineContentString
     *           自定义内容，为空或者json字符串
     * */
    public void onNotificationClicked(Context context, String title, String content, String selfDefineContentString){};

    /**
     * 接收通知到达的函数
     * @param context
     * @param title
     *           通知标题
     * @param content
     *           通知内容
     * @param selfDefineContentString
     *           自定义内容，为空或者json字符串
     * */
    public void onNotificationArrived(Context context, String title, String content, String selfDefineContentString){};

    /**
     * 接收通知删除的函数
     * @param context
     * @param title
     *           通知标题
     * @param content
     *           通知内容
     * @param selfDefineContentString
     *           自定义内容，为空或者json字符串
     * */
    public void onNotificationDeleted(Context context, String title, String content, String selfDefineContentString){};


    /**
     * Flyme6.0 上接收推送服务发送的通知栏消息
     * @param context
     * @param message 通知栏消息，多个通知栏消息以json数组的方式呈现
     *
     * [
            {
                "content": "测试PushDemo内容",
                "parameter": {
                "key": "value"
                },
                "activity": ".TestActivity",
                "title": "标题"
            },
            {
                "content": "测试PushDemo内容",
                "parameter": {
                "key": "value"
                },
                "activity": ".TestActivity",
                "title": "标题"
            }
    ]
     * */
    public void onNotifyMessageArrived(Context context,String message){};

    /**
     * push开关切换与修改状态回调
     * @param pushSwitchStatus
     * */
    public abstract void onPushStatus(Context context,PushSwitchStatus pushSwitchStatus);

    /**
     * 平台注册状态回调
     * */
    public abstract void onRegisterStatus(Context context,RegisterStatus registerStatus);

    /**
     * 平台反注册回调
     * */
    public abstract void onUnRegisterStatus(Context context,UnRegisterStatus unRegisterStatus);

    /**
     * 平台标签注册回调
     * */
    public abstract void onSubTagsStatus(Context context,SubTagsStatus subTagsStatus);

    /**
     * 平台别名注册回调
     * */
    public abstract void onSubAliasStatus(Context context,SubAliasStatus subAliasStatus);
 }
