/*
 * Decompiled with CFR 0.152.
 */
package com.medy.retrofitwrapper;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Base64;
import android.util.Log;
import android.webkit.MimeTypeMap;
import android.widget.Toast;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.medy.retrofitwrapper.BaseModel;
import com.medy.retrofitwrapper.ConnectionDetector;
import com.medy.retrofitwrapper.ParamJSON;
import com.medy.retrofitwrapper.RequestJSON;
import com.medy.retrofitwrapper.WebRequestErrorDialog;
import com.medy.retrofitwrapper.WebRequestInterface;
import com.medy.retrofitwrapper.WebServiceBaseRequestModel;
import com.medy.retrofitwrapper.WebServiceBaseResponseModel;
import com.medy.retrofitwrapper.WebServiceException;
import com.medy.retrofitwrapper.WebServiceHeader;
import com.medy.retrofitwrapper.WebServiceProgressResponseListener;
import com.medy.retrofitwrapper.WebServiceResponseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Sink;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class WebRequest
extends BaseModel {
    static BackGroundThreadExecutor backGroundThreadExecutor;
    static MainThreadExecutor mainThreadExecutor;
    public boolean isDebug = false;
    public static final String LINE_SEPARATOR = "\n";
    public static final String POST_REQ = "POST";
    public static final String GET_REQ = "GET";
    public static final String DELETE_REQ = "DELETE";
    public static final String PATCH_REQ = "PATCH";
    public static final long DEFAULT_TIME_OUT = 7199L;
    final long timeout;
    final HashMap<String, String> webRequestParams = new LinkedHashMap<String, String>();
    final HashMap<String, String> webRequestHeaders = new LinkedHashMap<String, String>();
    final HashMap<String, String> webRequestQuery = new LinkedHashMap<String, String>();
    final HashMap<String, File> webRequestFiles = new LinkedHashMap<String, File>();
    final HashMap<String, Object> extraDataMap = new LinkedHashMap<String, Object>();
    JsonObject webServiceRequestBody;
    final int webRequestId;
    final String webRequestUrl;
    final String webRequestMethod;
    final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }};
    Context context;
    String username;
    String password;
    Certificate certificate;
    WebRequestInterface webRequestInterface;
    String webRequestResponse;
    int responseCode = -1;
    HashSet<String> cookies;
    HashSet<String> requestCookies;
    boolean isCancelled;
    Call<ResponseBody> call;
    Exception webRequestException;
    WebRequestErrorDialog webRequestErrorDialog;
    ProgressDialog progressDialog;
    String progressMessage = "";
    private ConnectionDetector cd;
    Handler progressHandler = new Handler(Looper.getMainLooper());
    long totalLength;
    long uploadedLength;
    Object responsePojo;

    public Object getResponsePojo() {
        return this.responsePojo;
    }

    public void setResponsePojo(Object responsePojo) {
        this.responsePojo = responsePojo;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public long getUploadedLength() {
        return this.uploadedLength;
    }

    public WebRequest(int webRequestId, String webRequestUrl) {
        this(webRequestId, webRequestUrl, GET_REQ);
    }

    public WebRequest(int webRequestId, String webRequestUrl, String webRequestMethod) {
        this(webRequestId, webRequestUrl, webRequestMethod, 7199L);
    }

    public WebRequest(int webRequestId, String webRequestUrl, String webRequestMethod, long timeout) {
        this.webRequestId = webRequestId;
        this.webRequestMethod = webRequestMethod;
        this.timeout = timeout;
        Uri uri = Uri.parse((String)webRequestUrl);
        this.parseQueryParams(uri);
        String portString = "";
        if (uri.getPort() != -1) {
            portString = ":" + String.valueOf(uri.getPort());
        }
        this.webRequestUrl = uri.getScheme() + "://" + uri.getHost() + portString + uri.getPath();
        if (backGroundThreadExecutor == null) {
            backGroundThreadExecutor = new BackGroundThreadExecutor();
            backGroundThreadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        if (mainThreadExecutor == null) {
            mainThreadExecutor = new MainThreadExecutor();
            mainThreadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
    }

    public static BackGroundThreadExecutor getBackGroundThreadExecutor() {
        return backGroundThreadExecutor;
    }

    public static MainThreadExecutor getMainThreadExecutor() {
        return mainThreadExecutor;
    }

    private void parseQueryParams(Uri uri) {
        int end;
        this.webRequestQuery.clear();
        if (uri.isOpaque()) {
            return;
        }
        String query = uri.getEncodedQuery();
        if (query == null) {
            return;
        }
        int start = 0;
        do {
            int next;
            end = (next = query.indexOf(38, start)) == -1 ? query.length() : next;
            int separator = query.indexOf(61, start);
            if (separator > end || separator == -1) {
                separator = end;
            }
            String name = query.substring(start, separator);
            String value = separator < end ? query.substring(separator + 1, end) : "";
            this.webRequestQuery.put(Uri.decode((String)name), Uri.decode((String)value));
        } while ((start = end + 1) < query.length());
    }

    public void setRequestModel(WebServiceBaseRequestModel webServiceBaseRequestModel) {
        this.webRequestHeaders.clear();
        this.webRequestParams.clear();
        this.webRequestFiles.clear();
        if (webServiceBaseRequestModel != null) {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.serializeNulls();
            Gson gson = gsonBuilder.create();
            boolean asJsonRequest = webServiceBaseRequestModel.getClass().isAnnotationPresent(RequestJSON.class);
            if (asJsonRequest) {
                this.webServiceRequestBody = new JsonParser().parse(gson.toJson((Object)webServiceBaseRequestModel)).getAsJsonObject();
                return;
            }
            for (Field f : webServiceBaseRequestModel.getClass().getFields()) {
                f.setAccessible(true);
                try {
                    String key = f.getName();
                    if (key.equals("serialVersionUID")) continue;
                    Object value = f.get(webServiceBaseRequestModel);
                    boolean isHeader = f.isAnnotationPresent(WebServiceHeader.class);
                    if (value == null) continue;
                    if (isHeader) {
                        this.addHeader(key, (String)value);
                        continue;
                    }
                    boolean asJSON = f.isAnnotationPresent(ParamJSON.class);
                    if (f.getType() == List.class) {
                        List dataList = (List)value;
                        if (asJSON) {
                            this.addParam(key, gson.toJson((Object)dataList));
                            continue;
                        }
                        int i = 0;
                        for (Object data : dataList) {
                            String newKey = key + "[" + i + "]";
                            if (data instanceof File) {
                                this.addFile(newKey, (File)data);
                            } else {
                                this.addParam(newKey, String.valueOf(data));
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (f.getType() == Object.class) {
                        if (value instanceof File) {
                            this.addFile(key, (File)value);
                            continue;
                        }
                        this.addParam(key, String.valueOf(value));
                        continue;
                    }
                    if (f.getType() == File.class) {
                        this.addFile(key, (File)value);
                        continue;
                    }
                    if (asJSON) {
                        this.addParam(key, gson.toJson(value));
                        continue;
                    }
                    this.addParam(key, String.valueOf(value));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void printLog(String msg) {
        if (this.isDebug) {
            Log.e((String)(this.getClass().getSimpleName() + this.webRequestId), (String)msg);
        }
    }

    private boolean isDebugBuild(Context context) {
        try {
            String packageName = context.getPackageName();
            Bundle bundle = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            String manifest_pkg = null;
            if (bundle != null) {
                manifest_pkg = bundle.getString("manifest_pkg", null);
            }
            if (manifest_pkg != null) {
                packageName = manifest_pkg;
            }
            Class<?> buildConfig = Class.forName(packageName + ".BuildConfig");
            Field DEBUG = buildConfig.getField("DEBUG");
            DEBUG.setAccessible(true);
            return DEBUG.getBoolean(null);
        }
        catch (Throwable t) {
            String message = t.getMessage();
            if (message != null && message.contains("BuildConfig")) {
                return false;
            }
            return false;
        }
    }

    public int getWebRequestId() {
        return this.webRequestId;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void cancel() {
        if (this.call != null && !this.call.isCanceled()) {
            this.call.cancel();
        }
    }

    private void onRequestCompleted(Exception e, retrofit2.Response<ResponseBody> response) {
        int responseCode = -1;
        HashSet<String> cookies = null;
        String webRequestResponse = null;
        if (response != null) {
            responseCode = response.code();
            Response raw = response.raw();
            if (!raw.headers("Set-Cookie").isEmpty()) {
                cookies = new HashSet<String>();
                for (String header : raw.headers("Set-Cookie")) {
                    cookies.add(header);
                }
            }
            try {
                if (response.isSuccessful() && response.body() != null) {
                    webRequestResponse = ((ResponseBody)response.body()).string().trim();
                } else if (response.errorBody() != null) {
                    webRequestResponse = response.errorBody().string().trim();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        this.onRequestCompleted(e, responseCode, webRequestResponse, cookies);
    }

    public void onRequestCompleted(Exception e, int responseCode, String webRequestResponse, HashSet<String> cookies) {
        this.webRequestException = e;
        this.responseCode = responseCode;
        this.cookies = cookies;
        this.webRequestResponse = webRequestResponse;
    }

    public void setBasicAuth(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void addParam(String key, String value) {
        this.webRequestParams.put(key, value);
    }

    public void addHeader(String key, String value) {
        this.webRequestHeaders.put(key, value);
    }

    public void addQuery(String key, String value) {
        this.webRequestQuery.put(key, value);
    }

    public void clearQuery() {
        this.webRequestQuery.clear();
    }

    public void addFile(String key, File file) {
        this.webRequestFiles.put(key, file);
    }

    public void addExtra(String key, Object value) {
        this.extraDataMap.put(key, value);
    }

    public <T> T getExtraData(String key) {
        return (T)this.extraDataMap.get(key);
    }

    public static MultipartBody.Part createFilePart(String variableName, String filePath, MediaType mediaType) {
        File file = new File(filePath);
        RequestBody requestFile = RequestBody.create((MediaType)mediaType, (File)file);
        return MultipartBody.Part.createFormData((String)variableName, (String)file.getName(), (RequestBody)requestFile);
    }

    private Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    private Call<ResponseBody> generateRequest(Context context, WebServiceResponseListener webServiceResponseListener) {
        String basicAuth = this.getBasicAuth();
        if (basicAuth != null) {
            this.addHeader("Authorization", basicAuth);
        }
        if (this.requestCookies != null) {
            for (String cookie : this.requestCookies) {
                this.addHeader("Cookie", cookie);
            }
        }
        Call<ResponseBody> call = null;
        WebRequestInterface webRequestInterface = this.getWebServiceInterface(this.getCertificate());
        if (this.webRequestMethod.equals(DELETE_REQ)) {
            call = webRequestInterface.callDeleteRequest(this.webRequestUrl, this.webRequestQuery, this.webRequestHeaders);
        } else if (this.webRequestMethod.equals(GET_REQ)) {
            call = webRequestInterface.callGetRequest(this.webRequestUrl, this.webRequestQuery, this.webRequestHeaders);
        } else if (this.webRequestMethod.equals(POST_REQ) || this.webRequestMethod.equals(PATCH_REQ)) {
            Object value;
            if (this.webServiceRequestBody != null) {
                this.addHeader("Content-Type", "application/json");
                if (this.webRequestMethod.equals(POST_REQ)) {
                    call = webRequestInterface.callPostRequest(this.webRequestUrl, this.webRequestQuery, this.webRequestHeaders, this.webServiceRequestBody);
                } else if (this.webRequestMethod.equals(PATCH_REQ)) {
                    call = webRequestInterface.callPatchRequest(this.webRequestUrl, this.webRequestQuery, this.webRequestHeaders, this.webServiceRequestBody);
                }
                return call;
            }
            MultipartBody.Builder builder = new MultipartBody.Builder();
            if (!this.webRequestParams.isEmpty()) {
                for (String key : this.webRequestParams.keySet()) {
                    if (key == null || (value = this.webRequestParams.get(key)) == null) continue;
                    builder.addFormDataPart(key, (String)value);
                }
            }
            if (!this.webRequestFiles.isEmpty()) {
                for (String key : this.webRequestFiles.keySet()) {
                    String mimeType;
                    if (key == null || (value = this.webRequestFiles.get(key)) == null || (mimeType = this.getMimeType(((File)value).getAbsolutePath())) == null) continue;
                    RequestBody requestBody = new RequestBody((File)value, webServiceResponseListener){
                        final /* synthetic */ File val$value;
                        final /* synthetic */ WebServiceResponseListener val$webServiceResponseListener;
                        {
                            this.val$value = file;
                            this.val$webServiceResponseListener = webServiceResponseListener;
                        }

                        public MediaType contentType() {
                            return MediaType.parse((String)mimeType);
                        }

                        public long contentLength() {
                            return this.val$value.length();
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void writeTo(BufferedSink sink) throws IOException {
                            byte[] buffer = new byte[2048];
                            try (FileInputStream in = new FileInputStream(this.val$value);){
                                int read;
                                while ((read = in.read(buffer)) != -1) {
                                    sink.write(buffer, 0, read);
                                    WebRequest.this.uploadedLength += (long)read;
                                    if (this.val$webServiceResponseListener == null || !(this.val$webServiceResponseListener instanceof WebServiceProgressResponseListener)) continue;
                                    ((WebServiceProgressResponseListener)this.val$webServiceResponseListener).onWebRequestProgressChange(WebRequest.this);
                                    WebRequest.this.printProgressResponseLog();
                                }
                            }
                        }
                    };
                    builder.addFormDataPart(key, ((File)value).getName(), requestBody);
                }
            }
            MultipartBody body = builder.build();
            try {
                this.totalLength = body.contentLength();
                this.addHeader("Content-Type", "multipart/form-data; boundary=" + body.boundary());
                if (this.webRequestMethod.equals(POST_REQ)) {
                    call = webRequestInterface.callPostRequest(this.webRequestUrl, this.webRequestQuery, this.webRequestHeaders, (RequestBody)body);
                } else if (this.webRequestMethod.equals(PATCH_REQ)) {
                    call = webRequestInterface.callPatchRequest(this.webRequestUrl, this.webRequestQuery, this.webRequestHeaders, (RequestBody)body);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return call;
    }

    private String getBasicAuth() {
        if (this.username == null || this.password == null) {
            return null;
        }
        String basicAuth = "Basic " + Base64.encodeToString((byte[])String.format("%s:%s", this.username, this.password).getBytes(), (int)2);
        return basicAuth;
    }

    private String getMimeType(String filePath) {
        String mimeType = null;
        Uri uri = Uri.fromFile((File)new File(filePath));
        if (uri.getScheme().equals("content")) {
            ContentResolver cr = this.context.getContentResolver();
            mimeType = cr.getType(uri);
        } else {
            String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
            if (fileExtension != null && !fileExtension.trim().isEmpty()) {
                mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension.toLowerCase());
            }
        }
        return mimeType;
    }

    private String getWebRequestFullUrl() {
        StringBuilder builder = new StringBuilder(this.webRequestUrl);
        if (!this.webRequestQuery.isEmpty()) {
            builder.append("?");
            Set<Map.Entry<String, String>> entrySet = this.webRequestQuery.entrySet();
            int i = 0;
            for (Map.Entry<String, String> entry : entrySet) {
                if (i > 0) {
                    builder.append("&");
                }
                builder.append(entry.getKey()).append("=").append(entry.getValue());
                ++i;
            }
        }
        return builder.toString();
    }

    public String printRequestLog() {
        if (!this.isDebug) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("webRequestId:").append(this.webRequestId).append(LINE_SEPARATOR);
        stringBuilder.append("webRequestUrl:").append(this.getWebRequestFullUrl()).append(LINE_SEPARATOR);
        stringBuilder.append("webRequestMethod:").append(this.webRequestMethod).append(LINE_SEPARATOR);
        if (this.username != null && this.password != null) {
            stringBuilder.append("username:").append(this.username).append(LINE_SEPARATOR);
            stringBuilder.append("password:").append(this.password).append(LINE_SEPARATOR);
        }
        if (!this.webRequestHeaders.isEmpty()) {
            stringBuilder.append("Headers=>").append(LINE_SEPARATOR);
            for (Map.Entry<String, String> entry : this.webRequestHeaders.entrySet()) {
                stringBuilder.append(entry.getKey() + ":" + entry.getValue()).append(LINE_SEPARATOR);
            }
        }
        if (!this.webRequestParams.isEmpty()) {
            stringBuilder.append("Parameters=>").append(LINE_SEPARATOR);
            for (Map.Entry<String, String> entry : this.webRequestParams.entrySet()) {
                stringBuilder.append(entry.getKey() + ":" + entry.getValue()).append(LINE_SEPARATOR);
            }
        }
        if (!this.webRequestFiles.isEmpty()) {
            stringBuilder.append("FileParameters=>").append(LINE_SEPARATOR);
            for (Map.Entry<String, Object> entry : this.webRequestFiles.entrySet()) {
                stringBuilder.append(entry.getKey() + ":" + ((File)entry.getValue()).getAbsolutePath()).append(", MIME:").append(this.getMimeType(((File)entry.getValue()).getAbsolutePath())).append(LINE_SEPARATOR);
            }
        }
        if (this.webServiceRequestBody != null) {
            stringBuilder.append("webServiceRequestBody=>").append(LINE_SEPARATOR);
            stringBuilder.append(this.webServiceRequestBody).append(LINE_SEPARATOR);
        }
        if (this.requestCookies != null) {
            stringBuilder.append("requestCookies=>").append(LINE_SEPARATOR);
            stringBuilder.append(this.requestCookies).append(LINE_SEPARATOR);
        }
        this.printLog(stringBuilder.toString());
        return stringBuilder.toString();
    }

    public String printResponseLog() {
        if (!this.isDebug) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("webRequestId:").append(this.webRequestId).append(LINE_SEPARATOR);
        stringBuilder.append("webRequestUrl:").append(this.getWebRequestFullUrl()).append(LINE_SEPARATOR);
        stringBuilder.append("webRequestMethod:").append(this.webRequestMethod).append(LINE_SEPARATOR);
        if (this.username != null && this.password != null) {
            stringBuilder.append("username:").append(this.username).append(LINE_SEPARATOR);
            stringBuilder.append("password:").append(this.password).append(LINE_SEPARATOR);
        }
        if (this.webRequestException != null) {
            stringBuilder.append("webRequestException:").append(this.webRequestException.toString()).append(LINE_SEPARATOR);
        }
        if (this.webRequestResponse != null) {
            String result = this.getResponseString();
            stringBuilder.append("responseCode:").append(this.responseCode).append(LINE_SEPARATOR);
            stringBuilder.append("result:").append(result).append(LINE_SEPARATOR);
            if (this.cookies != null) {
                stringBuilder.append("receivedCookies:").append(this.cookies).append(LINE_SEPARATOR);
            }
        }
        this.printLog(stringBuilder.toString());
        return stringBuilder.toString();
    }

    public void printProgressResponseLog() {
        if (!this.isDebug) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("webRequestId:").append(this.webRequestId).append(LINE_SEPARATOR);
        stringBuilder.append("webRequestUrl:").append(this.getWebRequestFullUrl()).append(LINE_SEPARATOR);
        stringBuilder.append("---------progress -----------").append(LINE_SEPARATOR);
        stringBuilder.append("uploadedLength:" + this.uploadedLength).append(LINE_SEPARATOR);
        stringBuilder.append("totalLength:" + this.totalLength).append(LINE_SEPARATOR);
        stringBuilder.append("percent:" + (float)this.uploadedLength / (float)this.totalLength * 100.0f).append(LINE_SEPARATOR);
        stringBuilder.append("-----------------------------").append(LINE_SEPARATOR);
        this.printLog(stringBuilder.toString());
    }

    public void setProgressMessage(String progressMessage) {
        this.progressMessage = progressMessage;
    }

    public void showProgressDialog() {
        if (this.progressDialog != null && this.progressMessage != null && !this.progressMessage.trim().isEmpty()) {
            this.progressDialog.setMessage((CharSequence)this.progressMessage);
            this.progressDialog.show();
        }
    }

    public void hideProgressDialog() {
        if (this.progressDialog != null && this.progressDialog.isShowing()) {
            this.progressDialog.dismiss();
        }
    }

    public String getResponseString() {
        if (this.webRequestResponse != null) {
            return this.webRequestResponse;
        }
        return "";
    }

    public Exception getWebRequestException() {
        return this.webRequestException;
    }

    public WebServiceBaseResponseModel getBaseResponsePojo() throws JsonSyntaxException {
        String response = this.getResponseString();
        if (response != null && !response.trim().isEmpty()) {
            WebServiceBaseResponseModel baseWebServiceModel = (WebServiceBaseResponseModel)new Gson().fromJson(response, WebServiceBaseResponseModel.class);
            return baseWebServiceModel;
        }
        return null;
    }

    public boolean isSuccess() {
        if (this.webRequestException == null) {
            try {
                WebServiceBaseResponseModel baseWebServiceModel = this.getBaseResponsePojo();
                if (baseWebServiceModel != null && !baseWebServiceModel.isError()) {
                    return true;
                }
            }
            catch (JsonSyntaxException e) {
                this.showInvalidResponse(this.getResponseString());
            }
        } else if (this.webRequestException.getMessage() != null) {
            this.showInvalidResponse(this.webRequestException.getMessage());
        }
        return false;
    }

    public boolean checkSuccess() {
        if (this.webRequestException == null) {
            try {
                WebServiceBaseResponseModel baseWebServiceModel = this.getBaseResponsePojo();
                if (baseWebServiceModel != null && !baseWebServiceModel.isError()) {
                    return true;
                }
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
        return false;
    }

    public String getErrorMessageFromResponse() {
        try {
            WebServiceBaseResponseModel webServiceBaseResponseModel = this.getBaseResponsePojo();
            if (webServiceBaseResponseModel != null && webServiceBaseResponseModel.isError()) {
                return webServiceBaseResponseModel.getMessage();
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        if (this.webRequestException != null && this.webRequestException.getMessage() != null) {
            return this.webRequestException.getMessage();
        }
        return "";
    }

    public <T> T getResponsePojo(Class<T> tClass) {
        String response = this.getResponseString();
        if (response != null && !response.trim().isEmpty()) {
            try {
                return (T)new Gson().fromJson(response, tClass);
            }
            catch (JsonSyntaxException ignore) {
                this.showInvalidResponse(response);
            }
        }
        return null;
    }

    public <T> List<T> getResponsePojoList(TypeToken typeToken) {
        String response = this.getResponseString();
        if (response != null && !response.trim().isEmpty()) {
            try {
                return (List)new Gson().fromJson(response, typeToken.getType());
            }
            catch (JsonSyntaxException e) {
                this.showInvalidResponse(response);
            }
        }
        return null;
    }

    public <T> T getResponsePojoSimple(Class<T> tClass) {
        String response = this.getResponseString();
        if (response != null && !response.trim().isEmpty()) {
            try {
                return (T)new Gson().fromJson(response, tClass);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public <T> List<T> getResponsePojoSimpleList(TypeToken typeToken) {
        String response = this.getResponseString();
        if (response != null && !response.trim().isEmpty()) {
            try {
                return (List)new Gson().fromJson(response, typeToken.getType());
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public HashSet<String> getCookies() {
        return this.cookies;
    }

    public void setRequestCookies(HashSet<String> cookies) {
        this.requestCookies = cookies;
    }

    public void showInvalidResponse(String msg) {
        if (this.context == null) {
            return;
        }
        if (this.webRequestErrorDialog != null && this.webRequestErrorDialog.isShowing()) {
            this.webRequestErrorDialog.dismiss();
        }
        if (this.context instanceof Activity) {
            this.webRequestErrorDialog = new WebRequestErrorDialog(this.context, msg);
            this.webRequestErrorDialog.show();
        }
    }

    public void showToast(String message) {
        if (this.context == null || message == null || message.trim().isEmpty()) {
            return;
        }
        Toast.makeText((Context)this.context, (CharSequence)message, (int)0).show();
    }

    public Call<ResponseBody> generateCall(Context context) throws WebServiceException {
        this.isDebug = this.isDebugBuild(context);
        this.progressDialog = new ProgressDialog(context);
        this.progressDialog.setCancelable(false);
        this.context = context;
        if (this.cd == null) {
            this.cd = new ConnectionDetector(context);
        }
        this.call = this.generateRequest(context, null);
        this.isCancelled = this.call.isCanceled();
        this.printRequestLog();
        if (!this.cd.isConnectingToInternet()) {
            String msg = "Please check your internet connection.";
            WebServiceException e = new WebServiceException(msg, 122);
            this.onRequestCompleted(e, null);
            this.printResponseLog();
            throw e;
        }
        return this.call;
    }

    public void send(Context context) {
        if (!(context instanceof WebServiceResponseListener)) {
            throw new IllegalArgumentException("context should be implement WebServiceResponseListener");
        }
        this.send(context, (WebServiceResponseListener)context);
    }

    public void send(Context context, final WebServiceResponseListener webServiceResponseListener) {
        this.isDebug = this.isDebugBuild(context);
        this.progressDialog = new ProgressDialog(context);
        this.progressDialog.setCancelable(false);
        this.context = context;
        if (this.cd == null) {
            this.cd = new ConnectionDetector(context);
        }
        try {
            webServiceResponseListener.onWebRequestCall(this);
            this.call = this.generateRequest(context, webServiceResponseListener);
            this.isCancelled = this.call.isCanceled();
            this.printRequestLog();
            if (this.cd.isConnectingToInternet()) {
                this.showProgressDialog();
                try {
                    this.call.enqueue((Callback)new Callback<ResponseBody>(){

                        public void onResponse(Call<ResponseBody> call, retrofit2.Response<ResponseBody> response) {
                            WebRequest.this.isCancelled = call.isCanceled();
                            WebRequest.this.onRequestCompleted(null, (retrofit2.Response<ResponseBody>)response);
                            WebRequest.this.printResponseLog();
                            webServiceResponseListener.onWebRequestPreResponse(WebRequest.this);
                            mainThreadExecutor.handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    WebRequest.this.hideProgressDialog();
                                    webServiceResponseListener.onWebRequestResponse(WebRequest.this);
                                }
                            });
                        }

                        public void onFailure(Call<ResponseBody> call, Throwable t) {
                            WebRequest.this.isCancelled = call.isCanceled();
                            String message = t != null ? t.getMessage() : "";
                            WebRequest.this.onRequestCompleted(new IllegalStateException(message), (retrofit2.Response<ResponseBody>)null);
                            WebRequest.this.printResponseLog();
                            webServiceResponseListener.onWebRequestPreResponse(WebRequest.this);
                            mainThreadExecutor.handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    WebRequest.this.hideProgressDialog();
                                    webServiceResponseListener.onWebRequestResponse(WebRequest.this);
                                }
                            });
                        }
                    });
                }
                catch (Exception e) {
                    String msg = e.getMessage() == null ? "Exception in call webRequest" : e.getMessage();
                    WebServiceException e1 = new WebServiceException(msg, 121);
                    this.onRequestCompleted(e1, null);
                    this.printResponseLog();
                    mainThreadExecutor.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            WebRequest.this.hideProgressDialog();
                            webServiceResponseListener.onWebRequestResponse(WebRequest.this);
                        }
                    });
                }
            } else {
                String msg = "Please check your internet connection.";
                WebServiceException e = new WebServiceException(msg, 122);
                this.onRequestCompleted(e, null);
                this.printResponseLog();
                mainThreadExecutor.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        webServiceResponseListener.onWebRequestResponse(WebRequest.this);
                    }
                });
            }
        }
        catch (Exception e) {
            String msg = e.getMessage() == null ? "Exception in call webRequest" : e.getMessage();
            WebServiceException e1 = new WebServiceException(msg, 121);
            this.onRequestCompleted(e1, null);
            this.printResponseLog();
            mainThreadExecutor.handler.post(new Runnable(){

                @Override
                public void run() {
                    WebRequest.this.hideProgressDialog();
                    webServiceResponseListener.onWebRequestResponse(WebRequest.this);
                }
            });
        }
    }

    private WebRequestInterface getWebServiceInterface(Certificate certificate) {
        if (this.webRequestInterface == null) {
            OkHttpClient client = this.getOkHttpClient(certificate);
            this.webRequestInterface = (WebRequestInterface)new Retrofit.Builder().baseUrl("http://www.test.com/").client(client).callbackExecutor((Executor)backGroundThreadExecutor).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build().create(WebRequestInterface.class);
        }
        return this.webRequestInterface;
    }

    public void setWebRequestInterface(WebRequestInterface webRequestInterface) {
        this.webRequestInterface = webRequestInterface;
    }

    public OkHttpClient getOkHttpClient(Certificate certificate) {
        OkHttpClient.Builder okClientBuilder = new OkHttpClient.Builder();
        if (certificate != null) {
            try {
                SSLSocketFactory sslSocketFactory = this.getSSLConfig(certificate).getSocketFactory();
                if (sslSocketFactory != null) {
                    okClientBuilder.sslSocketFactory(sslSocketFactory);
                }
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
        }
        okClientBuilder.connectTimeout(this.timeout, TimeUnit.MILLISECONDS);
        okClientBuilder.readTimeout(this.timeout, TimeUnit.MILLISECONDS);
        okClientBuilder.writeTimeout(this.timeout, TimeUnit.MILLISECONDS);
        return okClientBuilder.build();
    }

    private SSLContext getSSLConfig(Certificate certificate) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        if (certificate == null) {
            return null;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        String keyStoreType = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(null, null);
        keyStore.setCertificateEntry("ca", certificate);
        String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        tmf.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, this.trustAllCerts, new SecureRandom());
        return sslContext;
    }

    static class MainThreadExecutor
    implements Executor {
        private final Handler handler = new Handler(Looper.getMainLooper());

        MainThreadExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            this.handler.post(r);
        }
    }

    static class BackGroundThreadExecutor
    implements Executor {
        private Handler mHandler = null;
        private HandlerThread mHandlerThread = null;

        public BackGroundThreadExecutor() {
            HandlerThread mHandlerThread = new HandlerThread("BackGroundThreadExecutor");
            mHandlerThread.start();
            this.mHandler = new Handler(mHandlerThread.getLooper());
        }

        @Override
        public void execute(Runnable command) {
            this.mHandler.post(command);
        }
    }

    final class CountingSink
    extends ForwardingSink {
        private long bytesWritten;
        private long contentLength;

        CountingSink(Sink delegate, long contentLength) {
            super(delegate);
            this.bytesWritten = 0L;
            this.contentLength = 0L;
            this.contentLength = contentLength;
        }

        public void write(Buffer source, long byteCount) throws IOException {
            super.write(source, byteCount);
            this.bytesWritten += byteCount;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }
    }
}

