/*
 * Decompiled with CFR 0.152.
 */
package com.medy.retrofitwrapper;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import android.util.Log;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;

public class ConnectionDetector {
    private Context _context;
    private ArrayList<NetworkInfo> connectedNetworks = new ArrayList();
    String ipAddress;

    public String getIpAddress() {
        return this.ipAddress;
    }

    public ConnectionDetector(Context context) {
        this._context = context;
    }

    public synchronized boolean isConnectingToInternet() {
        NetworkInfo[] info;
        this.connectedNetworks.clear();
        ConnectivityManager connectivity = (ConnectivityManager)this._context.getSystemService("connectivity");
        if (connectivity != null && (info = connectivity.getAllNetworkInfo()) != null) {
            for (int i = 0; i < info.length; ++i) {
                if (info[i].getState() != NetworkInfo.State.CONNECTED) continue;
                this.connectedNetworks.add(info[i]);
                this.ipAddress = this.getDeviceIpAddress();
                return true;
            }
        }
        return false;
    }

    private String getDeviceIpAddress() {
        NetworkInfo mWifi;
        String actualConnectedToNetwork = null;
        ConnectivityManager connManager = (ConnectivityManager)this._context.getSystemService("connectivity");
        if (connManager != null && (mWifi = connManager.getNetworkInfo(1)).isConnected()) {
            actualConnectedToNetwork = this.getWifiIp();
        }
        if (TextUtils.isEmpty(actualConnectedToNetwork)) {
            actualConnectedToNetwork = this.getNetworkInterfaceIpAddress();
        }
        if (TextUtils.isEmpty(actualConnectedToNetwork)) {
            actualConnectedToNetwork = "127.0.0.1";
        }
        return actualConnectedToNetwork;
    }

    private String getWifiIp() {
        WifiManager mWifiManager = (WifiManager)this._context.getSystemService("wifi");
        if (mWifiManager != null && mWifiManager.isWifiEnabled()) {
            int ip = mWifiManager.getConnectionInfo().getIpAddress();
            return (ip & 0xFF) + "." + (ip >> 8 & 0xFF) + "." + (ip >> 16 & 0xFF) + "." + (ip >> 24 & 0xFF);
        }
        return null;
    }

    public String getNetworkInterfaceIpAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface networkInterface = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = networkInterface.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    String host;
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (!(!inetAddress.isLoopbackAddress() && inetAddress instanceof Inet4Address ? !TextUtils.isEmpty((CharSequence)(host = inetAddress.getHostAddress())) : !inetAddress.isLoopbackAddress() && inetAddress instanceof Inet6Address && !TextUtils.isEmpty((CharSequence)(host = inetAddress.getHostAddress())))) continue;
                    return host;
                }
            }
        }
        catch (Exception ex) {
            Log.e((String)"IP Address", (String)"getLocalIpAddress", (Throwable)ex);
        }
        return null;
    }
}

