package com.medy.retrofitwrapper;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;


/**
 * @author Manish Kumar
 */


public class WebRequestErrorDialog extends Dialog {

    TextView tv_message;
    TextView tv_dismiss_btn;
    Handler handler = new Handler() {
        @Override
        public void handleMessage (Message msg) {
            super.handleMessage(msg);
            try {
                if (isShowing())
                    dismiss();
            } catch (Exception e) {

            }
        }
    };
    String msg = "";

    public WebRequestErrorDialog (@NonNull Context context, String msg) {
        super(context);
        this.msg = msg;
    }

    public void setMsg (String msg) {
        this.msg = msg;
    }

    @Override
    public void show () {
        super.show();
        handler.sendEmptyMessageDelayed(1, 3000);
    }

    @Override
    protected void onCreate (Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        getWindow().requestFeature(Window.FEATURE_NO_TITLE);
        getWindow().setBackgroundDrawableResource(R.color.colorPrimary_00);
        LayoutInflater inflate = LayoutInflater.from(getContext());
        View layout = inflate.inflate(R.layout.dialog_webrequest_response_invalid, null);

        //set dialog view
        setContentView(layout);
        //setup dialog window param
        WindowManager.LayoutParams wlmp = getWindow().getAttributes();
        wlmp.windowAnimations = R.style.LoginProcessDialog;
        wlmp.gravity = Gravity.BOTTOM;
        wlmp.height = WindowManager.LayoutParams.WRAP_CONTENT;
        wlmp.width = WindowManager.LayoutParams.MATCH_PARENT;
        wlmp.dimAmount = 0.0f;
        setTitle(null);
        setCancelable(true);
        setCanceledOnTouchOutside(true);
        setOnDismissListener(new OnDismissListener() {
            @Override
            public void onDismiss (DialogInterface dialog) {
                handler.removeMessages(1);
            }
        });
        setOnCancelListener(new OnCancelListener() {
            @Override
            public void onCancel (DialogInterface dialog) {
                handler.removeMessages(1);
            }
        });
        setOnShowListener(new OnShowListener() {
            @Override
            public void onShow (DialogInterface dialog) {
                if (WebRequestErrorDialog.this.msg != null) {
                    tv_message.setText(WebRequestErrorDialog.this.msg);
                } else {
                    tv_message.setText("");
                }
            }
        });
        tv_message = (TextView) layout.findViewById(R.id.tv_message);
        tv_dismiss_btn = (TextView) layout.findViewById(R.id.tv_dismiss_btn);
        tv_dismiss_btn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick (View v) {
                if (WebRequestErrorDialog.this.isShowing()) {
                    dismiss();
                }
            }
        });

    }

}
