/*
 * Decompiled with CFR 0.152.
 */
package com.medy.retrofitwrapper;

import android.app.ProgressDialog;
import android.content.Context;
import android.net.Uri;
import android.util.Base64;
import android.util.Log;
import android.webkit.MimeTypeMap;
import android.widget.Toast;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.medy.retrofitwrapper.ConnectionDetector;
import com.medy.retrofitwrapper.R;
import com.medy.retrofitwrapper.WebRequestErrorDialog;
import com.medy.retrofitwrapper.WebRequestInterface;
import com.medy.retrofitwrapper.WebServiceBaseRequestModel;
import com.medy.retrofitwrapper.WebServiceBaseResponseModel;
import com.medy.retrofitwrapper.WebServiceException;
import com.medy.retrofitwrapper.WebServiceHeader;
import com.medy.retrofitwrapper.WebServiceResponseListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class WebRequest {
    public boolean isDebug = false;
    public static final String LINE_SEPARATOR = "\n";
    public static final String POST_REQ = "POST";
    public static final String GET_REQ = "GET";
    public static final String DELETE_REQ = "DELETE";
    public static final int DEFAULT_TIME_OUT = 7199;
    final int timeout;
    final HashMap<String, String> webRequestParams = new LinkedHashMap<String, String>();
    final HashMap<String, String> webRequestHeaders = new LinkedHashMap<String, String>();
    final HashMap<String, String> webRequestQuery = new LinkedHashMap<String, String>();
    final HashMap<String, File> webRequestFiles = new LinkedHashMap<String, File>();
    final HashMap<String, Object> extraDataMap = new LinkedHashMap<String, Object>();
    final int webRequestId;
    final String webRequestUrl;
    final String webRequestMethod;
    final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }};
    Context context;
    String username;
    String password;
    String webRequestResponse;
    int responseCode = -1;
    Exception webRequestException;
    WebRequestErrorDialog webRequestErrorDialog;
    ProgressDialog progressDialog;
    String progressMessage = "";
    private ConnectionDetector cd;

    public WebRequest(int webRequestId, String webRequestUrl) {
        this(webRequestId, webRequestUrl, GET_REQ);
    }

    public WebRequest(int webRequestId, String webRequestUrl, String webRequestMethod) {
        this(webRequestId, webRequestUrl, webRequestMethod, 7199);
    }

    public WebRequest(int webRequestId, String webRequestUrl, String webRequestMethod, int timeout) {
        this.webRequestId = webRequestId;
        this.webRequestMethod = webRequestMethod;
        this.timeout = timeout;
        Uri uri = Uri.parse((String)webRequestUrl);
        this.parseQueryParams(uri);
        this.webRequestUrl = uri.getScheme() + "://" + uri.getHost() + uri.getPath();
    }

    private void parseQueryParams(Uri uri) {
        int end;
        this.webRequestQuery.clear();
        if (uri.isOpaque()) {
            return;
        }
        String query = uri.getEncodedQuery();
        if (query == null) {
            return;
        }
        int start = 0;
        do {
            int next;
            end = (next = query.indexOf(38, start)) == -1 ? query.length() : next;
            int separator = query.indexOf(61, start);
            if (separator > end || separator == -1) {
                separator = end;
            }
            String name = query.substring(start, separator);
            String value = separator < end ? query.substring(separator + 1, end) : "";
            this.webRequestQuery.put(Uri.decode((String)name), Uri.decode((String)value));
        } while ((start = end + 1) < query.length());
    }

    public void setRequestModel(WebServiceBaseRequestModel webServiceBaseRequestModel) {
        this.webRequestHeaders.clear();
        this.webRequestParams.clear();
        this.webRequestFiles.clear();
        if (webServiceBaseRequestModel != null) {
            for (Field f : webServiceBaseRequestModel.getClass().getFields()) {
                f.setAccessible(true);
                try {
                    String key = f.getName();
                    Object value = f.get(webServiceBaseRequestModel);
                    boolean isHeader = f.isAnnotationPresent(WebServiceHeader.class);
                    if (value == null) continue;
                    if (isHeader) {
                        this.addHeader(key, (String)value);
                        continue;
                    }
                    if (f.getType() == List.class) {
                        List dataList = (List)value;
                        int i = 0;
                        for (Object data : dataList) {
                            String newKey = key + "[" + i + "]";
                            if (data instanceof File) {
                                this.addFile(newKey, (File)data);
                                continue;
                            }
                            this.addParam(newKey, String.valueOf(data));
                        }
                        continue;
                    }
                    if (f.getType() == Object.class) {
                        if (value instanceof File) {
                            this.addFile(key, (File)value);
                            continue;
                        }
                        this.addParam(key, String.valueOf(value));
                        continue;
                    }
                    if (f.getType() == File.class) {
                        this.addFile(key, (File)value);
                        continue;
                    }
                    this.addParam(key, String.valueOf(value));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void printLog(String msg) {
        if (this.isDebug) {
            Log.e((String)(this.getClass().getSimpleName() + this.webRequestId), (String)msg);
        }
    }

    private boolean isDebugBuild(Context context) {
        try {
            String packageName = context.getPackageName();
            Class<?> buildConfig = Class.forName(packageName + ".BuildConfig");
            Field DEBUG = buildConfig.getField("DEBUG");
            DEBUG.setAccessible(true);
            return DEBUG.getBoolean(null);
        }
        catch (Throwable t) {
            String message = t.getMessage();
            if (message != null && message.contains("BuildConfig")) {
                return false;
            }
            return false;
        }
    }

    public int getWebRequestId() {
        return this.webRequestId;
    }

    private void onRequestCompleted(Exception e, Response<ResponseBody> response) {
        this.webRequestException = e;
        if (response != null) {
            this.responseCode = response.code();
            try {
                if (response.isSuccessful() && response.body() != null) {
                    this.webRequestResponse = ((ResponseBody)response.body()).string();
                } else if (response.errorBody() != null) {
                    this.webRequestResponse = response.errorBody().string();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void setBasicAuth(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void addParam(String key, String value) {
        this.webRequestParams.put(key, value);
    }

    public void addHeader(String key, String value) {
        this.webRequestHeaders.put(key, value);
    }

    public void addQuery(String key, String value) {
        this.webRequestQuery.put(key, value);
    }

    public void clearQuery() {
        this.webRequestQuery.clear();
    }

    public void addFile(String key, File file) {
        this.webRequestFiles.put(key, file);
    }

    public void addExtra(String key, Object value) {
        this.extraDataMap.put(key, value);
    }

    public Object getExtraData(String key) {
        return this.extraDataMap.get(key);
    }

    public static MultipartBody.Part createFilePart(String variableName, String filePath, MediaType mediaType) {
        File file = new File(filePath);
        RequestBody requestFile = RequestBody.create((MediaType)mediaType, (File)file);
        return MultipartBody.Part.createFormData((String)variableName, (String)file.getName(), (RequestBody)requestFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate getCertificate() {
        InputStream cert = null;
        Certificate certificate = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = this.context.getResources().openRawResource(R.raw.ubuntumemberslinodecom);
            certificate = cf.generateCertificate(cert);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (cert != null) {
                    cert.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return certificate;
    }

    private Call<ResponseBody> generateRequest(Context context) {
        String basicAuth = this.getBasicAuth();
        if (basicAuth != null) {
            this.addHeader("Authorization", basicAuth);
        }
        Call<ResponseBody> call = null;
        WebRequestInterface webRequestInterface = this.getWebServiceInterface(this.getCertificate());
        if (this.webRequestMethod.equals(DELETE_REQ)) {
            call = webRequestInterface.callDeleteRequest(this.webRequestUrl, this.webRequestQuery, this.webRequestHeaders);
        } else if (this.webRequestMethod.equals(GET_REQ)) {
            call = webRequestInterface.callGetRequest(this.webRequestUrl, this.webRequestQuery, this.webRequestHeaders);
        } else if (this.webRequestMethod.equals(POST_REQ)) {
            Object value;
            MultipartBody.Builder builder = new MultipartBody.Builder();
            if (!this.webRequestParams.isEmpty()) {
                for (String key : this.webRequestParams.keySet()) {
                    if (key == null || (value = this.webRequestParams.get(key)) == null) continue;
                    builder.addFormDataPart(key, (String)value);
                }
            }
            if (!this.webRequestFiles.isEmpty()) {
                for (String key : this.webRequestFiles.keySet()) {
                    String mimeType;
                    if (key == null || (value = this.webRequestFiles.get(key)) == null || (mimeType = this.getMimeType(((File)value).getAbsolutePath())) == null) continue;
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)mimeType), (File)value);
                    builder.addFormDataPart(key, ((File)value).getName(), requestBody);
                }
            }
            MultipartBody body = builder.build();
            this.addHeader("Content-Type", "multipart/form-data; boundary=" + body.boundary());
            call = webRequestInterface.callPostRequest(this.webRequestUrl, this.webRequestQuery, this.webRequestHeaders, body);
        }
        return call;
    }

    private String getBasicAuth() {
        if (this.username == null || this.password == null) {
            return null;
        }
        String basicAuth = "Basic " + Base64.encodeToString((byte[])String.format("%s:%s", this.username, this.password).getBytes(), (int)2);
        return basicAuth;
    }

    private String getMimeType(String filePath) {
        String type = null;
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)filePath);
        if (extension != null && !extension.trim().isEmpty()) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return type;
    }

    private String getWebRequestFullUrl() {
        StringBuilder builder = new StringBuilder(this.webRequestUrl);
        if (!this.webRequestQuery.isEmpty()) {
            builder.append("?");
            Set<Map.Entry<String, String>> entrySet = this.webRequestQuery.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                builder.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return builder.toString();
    }

    public void printRequestLog() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("webRequestId = ").append(this.webRequestId).append(LINE_SEPARATOR);
        stringBuilder.append("webRequestUrl = ").append(this.getWebRequestFullUrl()).append(LINE_SEPARATOR);
        stringBuilder.append("webRequestMethod = ").append(this.webRequestMethod).append(LINE_SEPARATOR);
        if (this.username != null && this.password != null) {
            stringBuilder.append("username = ").append(this.username).append(LINE_SEPARATOR);
            stringBuilder.append("password = ").append(this.password).append(LINE_SEPARATOR);
        }
        if (!this.webRequestHeaders.isEmpty()) {
            stringBuilder.append("Headers=>").append(LINE_SEPARATOR);
            for (Map.Entry<String, String> entry : this.webRequestHeaders.entrySet()) {
                stringBuilder.append(entry.getKey() + " = " + entry.getValue()).append(LINE_SEPARATOR);
            }
        }
        if (!this.webRequestParams.isEmpty()) {
            stringBuilder.append("Parameters=>").append(LINE_SEPARATOR);
            for (Map.Entry<String, String> entry : this.webRequestParams.entrySet()) {
                stringBuilder.append(entry.getKey() + " = " + entry.getValue()).append(LINE_SEPARATOR);
            }
        }
        if (!this.webRequestFiles.isEmpty()) {
            stringBuilder.append("FileParameters=>").append(LINE_SEPARATOR);
            for (Map.Entry<String, Object> entry : this.webRequestFiles.entrySet()) {
                stringBuilder.append(entry.getKey() + " = " + ((File)entry.getValue()).getAbsolutePath()).append(", MIME = ").append(this.getMimeType(((File)entry.getValue()).getAbsolutePath())).append(LINE_SEPARATOR);
            }
        }
        this.printLog(stringBuilder.toString());
    }

    public void printResponseLog() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("webRequestId = ").append(this.webRequestId).append(LINE_SEPARATOR);
        stringBuilder.append("webRequestUrl = ").append(this.getWebRequestFullUrl()).append(LINE_SEPARATOR);
        stringBuilder.append("webRequestMethod = ").append(this.webRequestMethod).append(LINE_SEPARATOR);
        if (this.username != null && this.password != null) {
            stringBuilder.append("username = ").append(this.username).append(LINE_SEPARATOR);
            stringBuilder.append("password = ").append(this.password).append(LINE_SEPARATOR);
        }
        if (this.webRequestException != null) {
            stringBuilder.append("webRequestException = ").append(this.webRequestException.toString()).append(LINE_SEPARATOR);
        }
        if (this.webRequestResponse != null) {
            String result = this.getResponseString();
            stringBuilder.append("responseCode = ").append(this.responseCode).append(LINE_SEPARATOR);
            stringBuilder.append("result = ").append(result).append(LINE_SEPARATOR);
        }
        this.printLog(stringBuilder.toString());
    }

    public void printRequestFullLog() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("webRequestId = ").append(this.webRequestId).append(LINE_SEPARATOR);
        stringBuilder.append("webRequestUrl = ").append(this.getWebRequestFullUrl()).append(LINE_SEPARATOR);
        stringBuilder.append("webRequestMethod = ").append(this.webRequestMethod).append(LINE_SEPARATOR);
        if (this.username != null && this.password != null) {
            stringBuilder.append("username = ").append(this.username).append(LINE_SEPARATOR);
            stringBuilder.append("password = ").append(this.password).append(LINE_SEPARATOR);
        }
        if (!this.webRequestHeaders.isEmpty()) {
            stringBuilder.append("Headers=>").append(LINE_SEPARATOR);
            for (Map.Entry<String, String> entry : this.webRequestHeaders.entrySet()) {
                stringBuilder.append(entry.getKey() + " = " + entry.getValue()).append(LINE_SEPARATOR);
            }
        }
        if (!this.webRequestParams.isEmpty()) {
            stringBuilder.append("Parameters=>").append(LINE_SEPARATOR);
            for (Map.Entry<String, String> entry : this.webRequestParams.entrySet()) {
                stringBuilder.append(entry.getKey() + " = " + entry.getValue()).append(LINE_SEPARATOR);
            }
        }
        if (!this.webRequestFiles.isEmpty()) {
            stringBuilder.append("FileParameters=>").append(LINE_SEPARATOR);
            for (Map.Entry<String, Object> entry : this.webRequestFiles.entrySet()) {
                stringBuilder.append(entry.getKey() + " = " + ((File)entry.getValue()).getAbsolutePath()).append(LINE_SEPARATOR);
            }
        }
        if (this.webRequestException != null) {
            stringBuilder.append("webRequestException = ").append(this.webRequestException.toString()).append(LINE_SEPARATOR);
        }
        if (this.webRequestResponse != null) {
            String result = this.getResponseString();
            stringBuilder.append("responseCode = ").append(this.responseCode).append(LINE_SEPARATOR);
            stringBuilder.append("result = ").append(result).append(LINE_SEPARATOR);
        }
        this.printLog(stringBuilder.toString());
    }

    public void setProgressMessage(String progressMessage) {
        this.progressMessage = progressMessage;
    }

    public void showProgressDialog() {
        if (this.progressDialog != null && this.progressMessage != null && !this.progressMessage.trim().isEmpty()) {
            this.progressDialog.setMessage((CharSequence)this.progressMessage);
            this.progressDialog.show();
        }
    }

    public void hideProgressDialog() {
        if (this.progressDialog != null && this.progressDialog.isShowing()) {
            this.progressDialog.dismiss();
        }
    }

    public String getResponseString() {
        if (this.webRequestResponse != null) {
            return this.webRequestResponse;
        }
        return "";
    }

    public WebServiceBaseResponseModel getBaseResponsePojo() throws JsonSyntaxException {
        String response = this.getResponseString();
        if (response != null && !response.trim().isEmpty()) {
            WebServiceBaseResponseModel baseWebServiceModel = (WebServiceBaseResponseModel)new Gson().fromJson(response, WebServiceBaseResponseModel.class);
            return baseWebServiceModel;
        }
        return null;
    }

    public boolean isSuccess() {
        if (this.webRequestException == null) {
            try {
                WebServiceBaseResponseModel baseWebServiceModel = this.getBaseResponsePojo();
                if (baseWebServiceModel != null && !baseWebServiceModel.isError()) {
                    return true;
                }
            }
            catch (JsonSyntaxException e) {
                this.showInvalidResponse(this.getResponseString());
            }
        } else if (this.webRequestException.getMessage() != null) {
            this.showInvalidResponse(this.webRequestException.getMessage());
        }
        return false;
    }

    public boolean checkSuccess() {
        if (this.webRequestException == null) {
            try {
                WebServiceBaseResponseModel baseWebServiceModel = this.getBaseResponsePojo();
                if (baseWebServiceModel != null && !baseWebServiceModel.isError()) {
                    return true;
                }
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
        return false;
    }

    public String getErrorMessageFromResponse() {
        try {
            WebServiceBaseResponseModel webServiceBaseResponseModel = this.getBaseResponsePojo();
            if (webServiceBaseResponseModel != null && webServiceBaseResponseModel.isError()) {
                return webServiceBaseResponseModel.getMessage();
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        if (this.webRequestException != null && this.webRequestException.getMessage() != null) {
            return this.webRequestException.getMessage();
        }
        return "";
    }

    public Object getResponsePojo(Class tClass) {
        String response = this.getResponseString();
        if (response != null && !response.trim().isEmpty()) {
            try {
                return new Gson().fromJson(response, tClass);
            }
            catch (JsonSyntaxException e) {
                this.showInvalidResponse(response);
            }
        }
        return null;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void showInvalidResponse(String msg) {
        if (this.context == null) {
            return;
        }
        if (this.webRequestErrorDialog != null && this.webRequestErrorDialog.isShowing()) {
            this.webRequestErrorDialog.dismiss();
        }
        this.webRequestErrorDialog = new WebRequestErrorDialog(this.context, msg);
        this.webRequestErrorDialog.show();
    }

    public void showToast(String message) {
        if (this.context == null || message == null || message.trim().isEmpty()) {
            return;
        }
        Toast.makeText((Context)this.context, (CharSequence)message, (int)0).show();
    }

    public void send(Context context) {
        if (!(context instanceof WebServiceResponseListener)) {
            throw new IllegalArgumentException("context should be implement WebServiceResponseListener");
        }
        this.send(context, (WebServiceResponseListener)context);
    }

    public void send(Context context, final WebServiceResponseListener webServiceResponseListener) {
        this.isDebug = this.isDebugBuild(context);
        this.progressDialog = new ProgressDialog(context);
        this.progressDialog.setCancelable(false);
        this.context = context;
        if (this.cd == null) {
            this.cd = new ConnectionDetector(context);
        }
        try {
            webServiceResponseListener.onWebRequestCall(this);
            Call<ResponseBody> call = this.generateRequest(context);
            this.printRequestLog();
            if (this.cd.isConnectingToInternet()) {
                this.showProgressDialog();
                call.enqueue((Callback)new Callback<ResponseBody>(){

                    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                        WebRequest.this.onRequestCompleted(null, (Response<ResponseBody>)response);
                        WebRequest.this.printResponseLog();
                        WebRequest.this.hideProgressDialog();
                        webServiceResponseListener.onWebRequestResponse(WebRequest.this);
                    }

                    public void onFailure(Call<ResponseBody> call, Throwable t) {
                        String message = t != null ? t.getMessage() : "";
                        WebRequest.this.onRequestCompleted(new IllegalStateException(message), (Response<ResponseBody>)null);
                        WebRequest.this.printResponseLog();
                        WebRequest.this.hideProgressDialog();
                        webServiceResponseListener.onWebRequestResponse(WebRequest.this);
                    }
                });
            } else {
                String msg = "Please check your internet connection.";
                WebServiceException e = new WebServiceException(msg, 122);
                this.onRequestCompleted(e, null);
                this.printResponseLog();
                webServiceResponseListener.onWebRequestResponse(this);
            }
        }
        catch (Exception e) {
            String msg = e.getMessage() == null ? "Exception in call webRequest" : e.getMessage();
            WebServiceException e1 = new WebServiceException(msg, 121);
            this.onRequestCompleted(e1, null);
            this.printResponseLog();
            this.hideProgressDialog();
            webServiceResponseListener.onWebRequestResponse(this);
        }
    }

    private WebRequestInterface getWebServiceInterface(Certificate certificate) {
        OkHttpClient client = this.getOkHttpClient(certificate);
        WebRequestInterface webRequestInterface = (WebRequestInterface)new Retrofit.Builder().baseUrl("http://www.test.com/").client(client).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build().create(WebRequestInterface.class);
        return webRequestInterface;
    }

    private OkHttpClient getOkHttpClient(Certificate certificate) {
        OkHttpClient.Builder okClientBuilder = new OkHttpClient.Builder();
        if (certificate != null) {
            try {
                SSLSocketFactory sslSocketFactory = this.getSSLConfig(certificate).getSocketFactory();
                if (sslSocketFactory != null) {
                    okClientBuilder.sslSocketFactory(sslSocketFactory);
                }
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
        }
        okClientBuilder.connectTimeout((long)this.timeout, TimeUnit.SECONDS);
        okClientBuilder.readTimeout((long)this.timeout, TimeUnit.SECONDS);
        okClientBuilder.writeTimeout((long)this.timeout, TimeUnit.SECONDS);
        return okClientBuilder.build();
    }

    private SSLContext getSSLConfig(Certificate certificate) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        if (certificate == null) {
            return null;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        String keyStoreType = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(null, null);
        keyStore.setCertificateEntry("ca", certificate);
        String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        tmf.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, this.trustAllCerts, new SecureRandom());
        return sslContext;
    }
}

