package com.medy.retrofitwrapper;

import java.util.Map;

import okhttp3.MultipartBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.HTTP;
import retrofit2.http.HeaderMap;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

/**
 * @author Manish Kumar
 */

public interface WebRequestInterface {

    @HTTP(method = "GET", path = "{api_path}")
    Call<ResponseBody> callGetRequest (@Path(value = "api_path", encoded = true) String apiPath,
                                       @QueryMap Map<String, String> queries,
                                       @HeaderMap Map<String, String> headers);


    @HTTP(method = "DELETE", path = "{api_path}")
    Call<ResponseBody> callDeleteRequest (@Path(value = "api_path", encoded = true) String apiPath,
                                          @QueryMap Map<String, String> queries,
                                          @HeaderMap Map<String, String> headers);

    @FormUrlEncoded
    @HTTP(method = "POST", path = "{api_path}", hasBody = true)
    Call<ResponseBody> callPostRequest (@Path(value = "api_path", encoded = true) String apiPath,
                                        @QueryMap Map<String, String> queries,
                                        @HeaderMap Map<String, String> headers,
                                        @FieldMap Map<String, String> params);


    @HTTP(method = "POST", path = "{api_path}", hasBody = true)
    Call<ResponseBody> callPostRequest (@Path(value = "api_path", encoded = true) String apiPath,
                                        @QueryMap Map<String, String> queries,
                                        @HeaderMap Map<String, String> headers,
                                        @Body MultipartBody multipartBody);

}
