/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.push;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import com.google.gson.Gson;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.R;
import com.mediatek.mcs.push.PushService;

public class McsPushBroadcastReceiver
extends BroadcastReceiver {
    static final String ACTION_RECEIVE = "com.mediatek.mcs.push.intent.RECEIVE";
    static final String ACTION_OPEN = "com.mediatek.mcs.push.intent.OPEN";
    static final String ACTION_DISMISS = "com.mediatek.mcs.push.intent.DISMISS";
    static final int NOTIFICATION_ID = 1;
    static final String KEY_PUSH_DATA = "pushData";
    static final String PROPERTY_PUSH_ICON = "com.mediatek.mcs.push.notification_icon";

    public void onReceive(Context context, Intent intent) {
        McsLog.d(context.getPackageName() + ": " + intent.getAction(), new Object[0]);
        if (ACTION_RECEIVE.equals(intent.getAction())) {
            this.onPushReceive(context, intent);
        } else if (ACTION_OPEN.equals(intent.getAction())) {
            this.onPushOpen(context, intent);
        } else if (ACTION_DISMISS.equals(intent.getAction())) {
            this.onPushDismiss(context, intent);
        }
    }

    protected void onPushReceive(Context context, Intent intent) {
        this.onMessageReceived(context, intent.getBundleExtra(KEY_PUSH_DATA));
    }

    protected void onPushOpen(Context context, Intent intent) {
        Class<? extends Activity> openActivity = this.getActivity(context, intent);
        if (openActivity != null) {
            Intent nextIntent = new Intent(context, openActivity);
            nextIntent.addFlags(0x10000000);
            context.startActivity(nextIntent);
        }
    }

    protected void onPushDismiss(Context context, Intent intent) {
        McsLog.d("onPushDismiss. User dismiss the notif", new Object[0]);
    }

    protected void onMessageReceived(Context context, Bundle data) {
        Device device = this.parseNotifDevice(data);
        String message = this.parseNotifMessage(data);
        String contentTitle = context.getString(context.getApplicationInfo().labelRes);
        NotificationCompat.BigTextStyle notifStyle = new NotificationCompat.BigTextStyle().setBigContentTitle((CharSequence)contentTitle).setSummaryText((CharSequence)device.getName()).bigText((CharSequence)message);
        Notification notif = new NotificationCompat.Builder(context).setAutoCancel(true).setStyle((NotificationCompat.Style)notifStyle).setWhen(System.currentTimeMillis()).setDefaults(-1).setSmallIcon(this.getSmallIcon(context)).setLargeIcon(this.getLargeIcon(context, device)).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)message).setTicker((CharSequence)message).setContentIntent(PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_OPEN), (int)0)).setDeleteIntent(PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_DISMISS), (int)0)).setGroup(context.getString(context.getApplicationInfo().labelRes)).setGroupSummary(false).build();
        int notifId = (int)System.currentTimeMillis();
        NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
        mNotificationManager.notify(notifId, notif);
    }

    protected Class<? extends Activity> getActivity(Context context, Intent intent) {
        return PushService.getDefaultPushCallback();
    }

    protected int getSmallIcon(Context context) {
        try {
            ApplicationInfo app = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = app.metaData;
            return bundle.getInt(PROPERTY_PUSH_ICON);
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            return R.drawable.default_notif_icon;
        }
    }

    protected Bitmap getLargeIcon(Context context, Device device) {
        return BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.getSmallIcon(context));
    }

    protected String parseNotifMessage(Bundle data) {
        String msg = data.getString("alert");
        return msg == null ? "" : msg;
    }

    protected Device parseNotifDevice(Bundle data) {
        try {
            return (Device)new Gson().fromJson(data.get("device").toString(), Device.class);
        }
        catch (Exception e) {
            McsLog.e(e, new Object[0]);
            return new Device("", "", "");
        }
    }

    public class Device {
        private String id;
        private String name;
        private String url;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public Device(String id, String name, String url) {
            this.id = id;
            this.name = name;
            this.url = url;
        }
    }
}

