package com.mediatek.mcs.smartconn;

import android.content.SharedPreferences.Editor;
import com.mediatek.mcs.pref.McsPreferences;
import lombok.Getter;
import lombok.Setter;

public class SmartConnectionAP implements McsPreferences {
	@Getter @Setter private String ssid;
	@Getter @Setter private String password;
	@Getter @Setter private boolean rememberAP;

	private static SmartConnectionAP INSTANCE = null;
	final String AP_SSID = "AP_SSID";
	final String AP_PASSWORD = "AP_PASSWORD";
	final String AP_REMEMBER_ME = "AP_REMEMBER_ME";

	private SmartConnectionAP() {
		setSsid(pref.getString(AP_SSID, ""));
		setPassword(pref.getString(AP_PASSWORD, ""));
		setRememberAP(pref.getBoolean(AP_REMEMBER_ME, false));
	}

	public static synchronized SmartConnectionAP getInstance() {
		if (INSTANCE == null) {
      INSTANCE = new SmartConnectionAP();
		}
		return INSTANCE;
	}

	public void clearPref() {
		setSsid("");
		setPassword("");
		setRememberAP(false);
    savePref();
	}

	public void savePref() {
		Editor editor = pref.edit();
		editor.putString(AP_SSID, getSsid());
		editor.putString(AP_PASSWORD, getPassword());
		editor.putBoolean(AP_REMEMBER_ME, isRememberAP());
		editor.commit();
	}
}
