package com.mediatek.mcs.net;

import android.content.Context;
import android.text.TextUtils;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;
import com.mediatek.mcs.Mcs;
import lombok.Setter;

public class RequestManager {
  static final String TAG = RequestManager.class.getSimpleName();
  private static RequestManager mInstance;
  @Setter private RequestQueue requestQueue;

  public static synchronized RequestManager getInstance() {
    if (mInstance == null) mInstance = new RequestManager();
    return mInstance;
  }

  public static void sendInBackground(Request request) {
    getInstance().addToRequestQueue(request, Mcs.getApplicationContext());
  }

  public RequestQueue getRequestQueue(Context ctx) {
    if (requestQueue == null) {
      requestQueue = Volley.newRequestQueue(ctx);
    }

    return requestQueue;
  }

  public <T> void addToRequestQueue(Request<T> req, String tag, Context ctx) {
    req.setTag(TextUtils.isEmpty(tag) ? TAG : tag);
    getRequestQueue(ctx).add(req);
  }

  public <T> void addToRequestQueue(Request<T> req, Context ctx) {
    req.setTag(TAG);
    getRequestQueue(ctx).add(req);
  }

  public void cancelPendingRequests(Object tag) {
    if (requestQueue != null) {
      requestQueue.cancelAll(tag);
    }
  }
}
