package com.mediatek.mcs.domain;

import com.google.gson.Gson;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.Utils.UIUtils;
import com.mediatek.mcs.entity.DataChannelEntity;
import com.mediatek.mcs.entity.DataPointEntity;
import com.mediatek.mcs.entity.DataPointEntity.Values;
import com.mediatek.mcs.entity.DataPointsUploadEntity;
import com.mediatek.mcs.entity.DataPointsUploadEntity.DataPoint;
import com.mediatek.mcs.entity.api.DeviceInfoEntity;
import com.mediatek.mcs.event.DataPointEvent;
import com.mediatek.mcs.exception.InvalidDataPointException;
import com.mediatek.mcs.net.McsJsonRequest;
import com.mediatek.mcs.net.RequestApi;
import com.mediatek.mcs.net.RequestManager;
import com.mediatek.mcs.socket.McsSocketListener;
import de.greenrobot.event.EventBus;
import lombok.Getter;
import org.json.JSONException;
import org.json.JSONObject;

public class McsDataChannel {

  @Getter String deviceId;
  @Getter String deviceKey;
  @Getter DataChannelEntity dataChannelEntity;
  @Getter McsSocketListener mcsSocketListener;

  public McsDataChannel(DeviceInfoEntity device, DataChannelEntity channelEntity,
      McsSocketListener listener) {
    this.deviceId = device.getDeviceId();
    this.deviceKey = device.getDeviceKey();
    this.dataChannelEntity = channelEntity;

    this.mcsSocketListener = listener;
  }

  public McsDataChannel(DeviceInfoEntity device, DataChannelEntity channelEntity) {
    this(device, channelEntity, null);

    this.mcsSocketListener = new McsSocketListener(response -> {
      try {
        JSONObject data = response.getJSONObject("updateDatapoint");
        DataPointEntity dp = new Gson().fromJson(data.toString(), DataPointEntity.class);

        setDataPointEntity(dp);
      } catch (JSONException e) {
        McsLog.e(e);
      }
    });
  }

  public String getChannelId() {
    return dataChannelEntity.getDataChnId();
  }

  public String getChannelName() {
    return dataChannelEntity.getName();
  }

  public int getChannelType() {
    return McsDataChannelType.getChannelType(dataChannelEntity);
  }

  public boolean isControllable() {
    return dataChannelEntity.isControllable();
  }

  public DataPointEntity getDataPointEntity() {
    return dataChannelEntity.getDataPoint();
  }

  public void setDataPointEntity(DataPointEntity dp) {
    if (dp != null) {
      dataChannelEntity.setDataPoint(dp);
      EventBus.getDefault().post(new DataPointEvent(getChannelId(), dp));
    }
  }

  /**
   * Submit given values, and pack it automatically by channelType.
   */
  public void submitDataPoint(Values values) {
    try {
      Values formattedValues = DataPointFormatter.formatValues(getDataChannelEntity(), values);
      String body = new Gson().toJson(
          new DataPointsUploadEntity(
              new DataPoint(getChannelId(), formattedValues)
          )
      );
      requestUploadDataPointForBase(body);
    } catch (InvalidDataPointException e) {
      UIUtils.toast(e.getMessage());
    }
  }

  public void requestUploadDataPointForBase(final String requestBody) {
    RequestManager.sendInBackground(new McsJsonRequest(
        McsJsonRequest.Method.POST,
        RequestApi.UPLOAD_DATA_POINT
            .replace("{deviceId}", deviceId),
        requestBody,
        response -> {
          McsLog.d(response.toString());
          /**
           * Do nothing here.
           * Use socket to update view instead.
           */
        },
        error -> McsLog.e(error)
    ));
  }
}
