package com.mediatek.mcs.Utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
  public static final String DISPLAY_DATE_FORMAT = "yyyy-MM-dd HH:mm";

  public static Calendar getStartOfToday() {
    Calendar c = Calendar.getInstance();
    c.set(Calendar.HOUR_OF_DAY, 0);
    c.set(Calendar.MINUTE, 0);
    c.set(Calendar.SECOND, 0);
    c.set(Calendar.MILLISECOND, 0);
    return c;
  }

  public static String getDateString(Date updatedAt) {
    try {
      return new SimpleDateFormat(DISPLAY_DATE_FORMAT, Locale.getDefault()).format(updatedAt);
    } catch (Exception e) {
      return "";
    }
  }

  public static String getDateString(Long timeMillis) {
    return getDateString(new Date(timeMillis));
  }
}
