package com.mediatek.mcs;

import android.util.Log;
import com.android.volley.VolleyLog;

public class McsLog {
  public static String TAG = "Mcs";

  public static void setLogLevel(boolean isDebuggable) {
    if (!isDebuggable) VolleyLog.DEBUG = false;
  }

  public static void v(String msg, Object... args) {
    if (Mcs.isDebuggable()) Log.v(TAG, buildMessage(msg, args));
  }

  public static void d(String msg, Object... args) {
    if (Mcs.isDebuggable()) Log.d(TAG, buildMessage(msg, args));
  }

  public static void e(String msg, Object... args) {
    Log.e(TAG, buildMessage(msg, args));
  }

  public static void e(Exception ex, Object... args) {
    Log.e(TAG, buildMessage(ex.toString(), args), ex);
  }

  static String buildMessage(String msg, Object... args) {
    return msg;
  }
}
