/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.net;

import android.content.Context;
import android.text.TextUtils;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;
import com.mediatek.mcs.Mcs;

public class RequestManager {
    static final String TAG = RequestManager.class.getSimpleName();
    private static RequestManager mInstance;
    private RequestQueue requestQueue;

    public static synchronized RequestManager getInstance() {
        if (mInstance == null) {
            mInstance = new RequestManager();
        }
        return mInstance;
    }

    public static void sendInBackground(Request request) {
        RequestManager.getInstance().addToRequestQueue(request, Mcs.getApplicationContext());
    }

    public RequestQueue getRequestQueue(Context ctx) {
        if (this.requestQueue == null) {
            this.requestQueue = Volley.newRequestQueue((Context)ctx);
        }
        return this.requestQueue;
    }

    public <T> void addToRequestQueue(Request<T> req, String tag, Context ctx) {
        req.setTag((Object)(TextUtils.isEmpty((CharSequence)tag) ? TAG : tag));
        this.getRequestQueue(ctx).add(req);
    }

    public <T> void addToRequestQueue(Request<T> req, Context ctx) {
        req.setTag((Object)TAG);
        this.getRequestQueue(ctx).add(req);
    }

    public void cancelPendingRequests(Object tag) {
        if (this.requestQueue != null) {
            this.requestQueue.cancelAll(tag);
        }
    }

    public void setRequestQueue(RequestQueue requestQueue) {
        this.requestQueue = requestQueue;
    }
}

