/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.domain;

import android.text.TextUtils;
import android.util.Patterns;
import com.android.volley.Request;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.R;
import com.mediatek.mcs.Utils.ResponseMessage;
import com.mediatek.mcs.domain.McsResponse;
import com.mediatek.mcs.domain.McsSession$$Lambda$1;
import com.mediatek.mcs.domain.McsSession$$Lambda$2;
import com.mediatek.mcs.domain.McsSession$$Lambda$3;
import com.mediatek.mcs.domain.McsSession$$Lambda$4;
import com.mediatek.mcs.domain.McsSession$$Lambda$5;
import com.mediatek.mcs.entity.AuthEntity;
import com.mediatek.mcs.exception.InvalidSessionException;
import com.mediatek.mcs.exception.SdkInstallationException;
import com.mediatek.mcs.net.McsJsonRequest;
import com.mediatek.mcs.net.RequestApi;
import com.mediatek.mcs.net.RequestManager;
import com.mediatek.mcs.net.RequestUtils;
import com.mediatek.mcs.net.SignInRequest;
import com.mediatek.mcs.pref.McsUser;
import com.mediatek.mcs.pref.McsUserInfo;
import com.mediatek.mcs.push.McsPushInstallation;
import java.util.HashMap;
import org.json.JSONObject;

public class McsSession {
    private static McsSession INSTANCE = new McsSession();
    protected McsResponse.SuccessListener<JSONObject> successListener;
    protected McsResponse.ErrorListener errorListener;

    protected McsSession() {
    }

    public static McsSession getInstance() {
        return INSTANCE;
    }

    public McsUser getCurrentUser() {
        return McsUser.getInstance();
    }

    public boolean isSignedIn() {
        return !"".equals(this.getCurrentUser().getAccessToken());
    }

    public String getAccessToken() {
        return McsUser.getInstance().getAccessToken();
    }

    public McsUserInfo getUserInfo() {
        return McsUserInfo.getInstance();
    }

    public void saveTokenResultsToPref(AuthEntity.AccessToken.Results results) {
        McsUser.getInstance().setEmail(results.getEmail());
        McsUser.getInstance().setToken(results.getToken());
        McsUser.getInstance().setAccessToken(results.getAccessToken());
        McsUser.getInstance().savePref();
        McsUserInfo.getInstance().setNickname(results.getNickname());
        McsUserInfo.getInstance().setUserImageURL(results.getUserImageURL());
        McsUserInfo.getInstance().savePref();
    }

    public void requestSignIn(String email, String pwd, McsResponse.SuccessListener<JSONObject> successListener) {
        this.requestSignIn(email, pwd, successListener, McsSession$$Lambda$1.lambdaFactory$());
    }

    public void requestSignIn(String email, String pwd, McsResponse.SuccessListener<JSONObject> successListener, McsResponse.ErrorListener errorListener) {
        this.successListener = successListener;
        this.errorListener = errorListener;
        if (this.isValidAuth(email, pwd)) {
            McsUser.getInstance().setEmail(email);
            McsUser.getInstance().setPassword(pwd);
            this.requestSignInToken();
        }
    }

    public void requestSignOut(McsResponse.SuccessListener<JSONObject> successListener) {
        McsPushInstallation.getInstance().requestUnRegisterMobile();
        McsUser.getInstance().clearPref();
        McsUserInfo.getInstance().clearPref();
        successListener.onSuccess(ResponseMessage.create("Sign out successfully"));
    }

    private void requestSignInToken() {
        RequestManager.sendInBackground(new SignInRequest(1, RequestApi.SIGN_IN, SignInRequest.getSignInParams(), McsSession$$Lambda$2.lambdaFactory$(this), McsSession$$Lambda$3.lambdaFactory$(this)));
    }

    protected void requestUserInfo() {
        RequestManager.sendInBackground((Request)new McsJsonRequest(RequestApi.USER_INFO, McsSession$$Lambda$4.lambdaFactory$(this), McsSession$$Lambda$5.lambdaFactory$(this)){

            public HashMap<String, String> getHeaders() {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("Authorization", "Bearer " + McsSession.getInstance().getAccessToken());
                return params;
            }
        });
    }

    protected boolean isValidAuth() {
        boolean isValid = false;
        if (TextUtils.isEmpty((CharSequence)Mcs.MCS_APP_ID) || TextUtils.isEmpty((CharSequence)Mcs.MCS_APP_SECRET)) {
            this.errorListener.onError(new SdkInstallationException(R.string.error_install_credential_invalid));
        } else {
            isValid = true;
        }
        return isValid;
    }

    protected boolean isValidAuth(String _user, String _pwd) {
        boolean isValid = false;
        if (TextUtils.isEmpty((CharSequence)Mcs.MCS_APP_ID) || TextUtils.isEmpty((CharSequence)Mcs.MCS_APP_SECRET)) {
            this.errorListener.onError(new SdkInstallationException(R.string.error_install_credential_invalid));
        } else if (_user.equals("")) {
            this.errorListener.onError(new InvalidSessionException(R.string.error_signin_username_blank));
        } else if (!this.isEmailValid(_user)) {
            this.errorListener.onError(new InvalidSessionException(R.string.error_signin_email_invalid));
        } else if (_pwd.equals("")) {
            this.errorListener.onError(new InvalidSessionException(R.string.error_signin_pwd_blank));
        } else {
            isValid = true;
        }
        return isValid;
    }

    private boolean isEmailValid(CharSequence email) {
        return Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    public void setErrorListener(McsResponse.ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    private /* synthetic */ void lambda$requestUserInfo$10(Exception error) {
        this.errorListener.onError(RequestUtils.parseVolleyError(error));
    }

    private /* synthetic */ void lambda$requestUserInfo$9(JSONObject response) {
        McsUserInfo.getInstance().saveToPref(response);
        if (McsPushInstallation.getInstance().isPushInstalled()) {
            McsPushInstallation.getInstance().requestRegisterMobile(this.successListener, this.errorListener);
        } else {
            this.successListener.onSuccess(ResponseMessage.create("Sign in without register mobile"));
        }
    }

    private /* synthetic */ void lambda$requestSignInToken$8(Exception error) {
        this.errorListener.onError(RequestUtils.parseVolleyError(error));
    }

    private /* synthetic */ void lambda$requestSignInToken$7(JSONObject response) {
        McsUser.getInstance().saveToPref(response);
        this.requestUserInfo();
    }

    private static /* synthetic */ void lambda$requestSignIn$6(Exception error) {
        McsLog.e(error.getMessage(), new Object[0]);
    }

    static /* synthetic */ void access$lambda$0(Exception exception) {
        McsSession.lambda$requestSignIn$6(exception);
    }

    static /* synthetic */ void access$lambda$1(McsSession mcsSession, JSONObject jSONObject) {
        mcsSession.lambda$requestSignInToken$7(jSONObject);
    }

    static /* synthetic */ void access$lambda$2(McsSession mcsSession, Exception exception) {
        mcsSession.lambda$requestSignInToken$8(exception);
    }

    static /* synthetic */ void access$lambda$3(McsSession mcsSession, JSONObject jSONObject) {
        mcsSession.lambda$requestUserInfo$9(jSONObject);
    }

    static /* synthetic */ void access$lambda$4(McsSession mcsSession, Exception exception) {
        mcsSession.lambda$requestUserInfo$10(exception);
    }
}

