package com.mediatek.mcs.push;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.gson.Gson;
import com.mediatek.mcs.BuildConfig;
import com.mediatek.mcs.Mcs;

public class McsRegisterMobile {
  static final int MOBILE_TYPE_ANDROID = 1;

  private String name;
  private String regToken;
  private String appKey;
  private int mobileTypeId;
  private Info info;

  public McsRegisterMobile(String regToken, String appKey) {
    this.name = Build.MANUFACTURER.toUpperCase() + " " + Build.MODEL;
    this.regToken = regToken;
    this.appKey = appKey;
    this.mobileTypeId = MOBILE_TYPE_ANDROID;
    this.info = new Info();
  }

  public String toString() {
    return new Gson().toJson(this, McsRegisterMobile.class);
  }

  public static class Info {
    private String mcsAppId;
    private String mcsAppSecret;
    private String carrier;
    private String manufacturer;
    private String model;
    private String appIdentifier;
    private String appName;
    private String appVersionName;
    private int appVersionCode;
    private int sdkVersion;
    private ScreenMetrics metrics;

    public Info() {
      Context context = Mcs.getApplicationContext();
      this.mcsAppId = Mcs.MCS_APP_ID;
      this.mcsAppSecret = Mcs.MCS_APP_SECRET;

      String carrierName = ((TelephonyManager) Mcs.getApplicationContext()
          .getSystemService(Context.TELEPHONY_SERVICE))
          .getNetworkOperatorName();
      this.carrier = (carrierName == null)? "no carrier" : carrierName;
      this.manufacturer = Build.MANUFACTURER.toUpperCase();
      this.model = Build.MODEL;

      this.appIdentifier = context.getPackageName();
      this.appName = context.getString(context.getApplicationInfo().labelRes);
      try {
        this.appVersionName = context.getPackageManager().getPackageInfo(appIdentifier, 0).versionName;
        this.appVersionCode = context.getPackageManager().getPackageInfo(appIdentifier, 0).versionCode;
      } catch (PackageManager.NameNotFoundException e) {
        this.appVersionName = BuildConfig.VERSION_NAME;
        this.appVersionCode = BuildConfig.VERSION_CODE;
      }

      this.sdkVersion = Build.VERSION.SDK_INT;
      this.metrics = new ScreenMetrics();
    }

    public static class ScreenMetrics {
      private float density;
      private int widthPixels;
      private int heightPixels;
      private double diagonalInches;

      public ScreenMetrics() {
        DisplayMetrics metrics = Mcs.getApplicationContext().getResources().getDisplayMetrics();

        this.density = metrics.density;
        this.widthPixels = metrics.widthPixels;
        this.heightPixels = metrics.heightPixels;

        float widthDpi = metrics.xdpi;
        float heightDpi = metrics.ydpi;
        float widthInches = widthPixels / widthDpi;
        float heightInches = heightPixels / heightDpi;

        this.diagonalInches = Math.sqrt((widthInches * widthInches) + (heightInches * heightInches));
      }
    }
  }

}
