package com.mediatek.mcs.net;

import com.mediatek.mcs.domain.McsResponse;
import java.util.Map;
import org.json.JSONObject;

public class McsJsonRequest extends AuthedJsonRequest {

  public interface Method {
    int GET = 0;
    int POST = 1;
    int PUT = 2;
    int DELETE = 3;
  }

  /**
   * Create a new request with some customized headers & requestBody.
   */
  public McsJsonRequest(int method, String url, Map<String, String> headers, String requestBody,
      McsResponse.SuccessListener<JSONObject> listener, McsResponse.ErrorListener errorListener) {
    super(method, url, headers, requestBody, listener, errorListener);
  }

  public McsJsonRequest(String url, McsResponse.SuccessListener<JSONObject> listener,
      McsResponse.ErrorListener errorListener) {
    this(Method.GET, url, listener, errorListener);
  }

  public McsJsonRequest(int method, String url, McsResponse.SuccessListener<JSONObject> listener,
      McsResponse.ErrorListener errorListener) {
    this(method, url, null, null, listener, errorListener);
  }

  public McsJsonRequest(int method, String url, String requestBody,
      McsResponse.SuccessListener<JSONObject> listener, McsResponse.ErrorListener errorListener) {
    this(method, url, null, requestBody, listener, errorListener);
  }

  /**
   * With default {@link RequestErrorListener}
   */
  public McsJsonRequest(String url, McsResponse.SuccessListener<JSONObject> listener) {
    this(Method.GET, url, listener, new RequestErrorListener());
  }

  public McsJsonRequest(int method, String url, String requestBody,
      McsResponse.SuccessListener<JSONObject> listener) {
    this(method, url, null, requestBody, listener, new RequestErrorListener());
  }
}
