package com.mediatek.mcs.entity.api;

import com.mediatek.mcs.entity.DataChannelEntity;
import com.mediatek.mcs.entity.ProductEntity;
import com.mediatek.mcs.net.RequestApi;
import java.util.Date;
import java.util.List;
import lombok.AccessLevel;
import lombok.Getter;

@Getter public class DeviceInfoEntity extends ApiResults<DeviceInfoEntity> {
  private String deviceId;
  private String deviceKey;
  private String deviceName;
  private String deviceDescription;

  private String trustIpRange;
  private String lastIp;
  @Getter(AccessLevel.NONE) private String deviceImageURL;

  private boolean isVerified;
  private boolean isActive;
  private boolean isTest;
  private Date activatedAt;
  private Date deactivatedAt;

  private String privilege;
  private ProductEntity product;
  private Firmware fw;
  private List<DataChannelEntity> dataChannels;

  public String getDeviceImageURL() {
    return ("productBanner.jpg".equals(deviceImageURL) || "".equals(deviceImageURL)) ? ""
        : RequestApi.getImageServerPrefix() + deviceImageURL;
  }

  @Getter public class Firmware {
    private String fwId;
    private String description;
    private String version;
    private String name;
  }
}
