package com.mediatek.mcs.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.AllArgsConstructor;

/**
 * MCS API schema for upload data points.
 */
public class DataPointsUploadEntity extends McsEntity {
  private List<DataPoint> datapoints = new ArrayList<>();

  public DataPointsUploadEntity(DataPoint... dps) {
    Collections.addAll(this.datapoints, dps);
  }

  @AllArgsConstructor
  public static class DataPoint {
    private String dataChnId;
    private DataPointEntity.Values values;
  }
}
