package com.mediatek.mcs.entity;

import lombok.Getter;
import lombok.Setter;

@Getter public class DataChannelEntity extends McsEntity {
  private String dataChnId;
  private String name;
  private String description;
  private ChannelType channelType;
  private Format format;
  private boolean isHidden;
  private boolean isControllable;
  private UnitTypeEntity unitType;
  @Setter private DataPointEntity dataPoint;

  @Getter public class ChannelType {
    private Integer dataChnTypeId;
    private String name;
  }

  @Getter public class Format {
    /**
     * Integer, Float
     */
    private Integer unitTypes;
    private Float lowerbound; // controller only
    private Float upperbound; // controller only

    /**
     * Category
     */
    private Result[] results;

    @Getter public class Result {
      private String name;
      private String value;
    }
  }
}
