/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.socket;

import com.mediatek.mcs.domain.McsDataChannel;
import com.mediatek.mcs.socket.McsSocket;
import com.mediatek.mcs.socket.McsSocketListener;
import io.socket.emitter.Emitter;

public class SocketManager {
    public static String getSocketUrl(McsDataChannel channel) {
        String string2 = "/devices/{deviceId}/dataChannels/{datachannelId}";
        return "/devices/{deviceId}/dataChannels/{datachannelId}".replace("{deviceId}", channel.getDeviceId()).replace("{datachannelId}", channel.getChannelId());
    }

    public static String getSocketUrl(String mobileId) {
        String string2 = "/mobiles/{mobileId}/switch";
        return "/mobiles/{mobileId}/switch".replace("{mobileId}", mobileId);
    }

    public static void registerSocket(McsDataChannel dataChannel, McsSocketListener socketListener) {
        McsSocket.getInstance().on(SocketManager.getSocketUrl(dataChannel), (Emitter.Listener)socketListener);
    }

    public static void unregisterSocket(McsDataChannel channel, McsSocketListener socketListener) {
        McsSocket.getInstance().off(SocketManager.getSocketUrl(channel), (Emitter.Listener)socketListener);
    }

    public static void registerSocket(String mobileId, McsSocketListener socketListener) {
        McsSocket.getInstance().on(SocketManager.getSocketUrl(mobileId), (Emitter.Listener)socketListener);
    }

    public static void unregisterSocket(String mobileId, McsSocketListener socketListener) {
        McsSocket.getInstance().off(SocketManager.getSocketUrl(mobileId), (Emitter.Listener)socketListener);
    }

    public static void connectSocket() {
        McsSocket.getInstance().connect();
    }

    public static void disconnectSocket() {
        McsSocket.getInstance().disconnect();
    }
}

