/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.net;

import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.domain.McsResponse;
import com.mediatek.mcs.domain.McsSession;
import com.mediatek.mcs.net.McsRequestHelper;
import com.mediatek.mcs.net.RequestErrorListener;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SignInRequest
extends Request<JSONObject> {
    private McsResponse.SuccessListener<JSONObject> listener;
    private Map<String, String> params;

    public SignInRequest(int method, String url, Map<String, String> params, McsResponse.SuccessListener<JSONObject> listener) {
        this(method, url, params, listener, new RequestErrorListener());
    }

    public SignInRequest(int method, String url, Map<String, String> params, McsResponse.SuccessListener<JSONObject> listener, McsResponse.ErrorListener errorListener) {
        super(method, url, McsRequestHelper.transformErrorListener(errorListener));
        this.params = params;
        this.listener = listener;
    }

    public static Map<String, String> getSignInParams() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("email", McsSession.getInstance().getCurrentUser().getEmail());
        hashMap.put("password", McsSession.getInstance().getCurrentUser().getPassword());
        return hashMap;
    }

    public static Map<String, String> getSignInParams(String refreshToken) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("token", refreshToken);
        return hashMap;
    }

    protected Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, String> getHeaders() throws AuthFailureError {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Content-Type", "application/x-www-form-urlencoded");
        hashMap.put("Authorization", "Basic " + Mcs.MCS_CLIENT_ID);
        return hashMap;
    }

    protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
        try {
            String string2 = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
            return Response.success((Object)new JSONObject(string2), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return Response.error((VolleyError)new ParseError((Throwable)unsupportedEncodingException));
        }
        catch (JSONException jSONException) {
            return Response.error((VolleyError)new ParseError((Throwable)jSONException));
        }
    }

    protected void deliverResponse(JSONObject response) {
        this.listener.onSuccess(response);
    }
}

