/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.domain;

import com.google.gson.Gson;
import com.mediatek.mcs.R;
import com.mediatek.mcs.domain.DataPointFormatter;
import com.mediatek.mcs.entity.DataPointEntity;
import com.mediatek.mcs.exception.InvalidDataPointException;

public class McsGeoPoint {
    private float latitude;
    private float longitude;
    private float altitude;

    public McsGeoPoint(DataPointEntity.Values values) throws InvalidDataPointException {
        this(Float.toString(values.getLatitude().floatValue()), Float.toString(values.getLongitude().floatValue()), Float.toString(values.getAltitude().floatValue()));
    }

    public McsGeoPoint(String latString, String lngString, String altString) throws InvalidDataPointException {
        if ("".equals(latString) || "".equals(lngString)) {
            throw new InvalidDataPointException(R.string.error_invalid_upload_value);
        }
        if ("".equals(altString)) {
            altString = "0";
        }
        try {
            float f2 = Float.parseFloat(latString);
            float f3 = Float.parseFloat(lngString);
            float f4 = Float.parseFloat(altString);
            this.longitude = -180.0f <= f3 && f3 < 180.0f ? f3 : ((f3 - 180.0f) % 360.0f + 360.0f) % 360.0f - 180.0f;
            this.latitude = Math.max(-90.0f, Math.min(90.0f, f2));
            this.altitude = f4;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDataPointException(R.string.error_invalid_upload_dp, (Throwable)numberFormatException);
        }
    }

    public McsGeoPoint trim() throws InvalidDataPointException {
        this.latitude = Float.parseFloat(DataPointFormatter.trimGeoValue(Float.valueOf(this.latitude)));
        this.longitude = Float.parseFloat(DataPointFormatter.trimGeoValue(Float.valueOf(this.longitude)));
        this.altitude = Float.parseFloat(DataPointFormatter.trimGeoValue(Float.valueOf(this.altitude)));
        return this;
    }

    public float getLatitude() {
        return this.latitude;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public float getAltitude() {
        return this.altitude;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }
}

