package com.mediatek.mcs.smartconn;

import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.preference.PreferenceManager;
import com.mediatek.mcs.Mcs;

public class SmartConnectionAP {
	private static SmartConnectionAP instance = null;
	private String ssid;
	private String password;
	private boolean rememberAP;
	private SharedPreferences pref;
	private static final String AP_SSID = "AP_SSID";
	private static final String AP_PASSWORD = "AP_PASSWORD";
	private static final String AP_REMEMBER_ME = "AP_REMEMBER_ME";

	private SmartConnectionAP() {
    pref = PreferenceManager.getDefaultSharedPreferences(Mcs.getApplicationContext());

		setSsid(pref.getString(AP_SSID, ""));
		setPassword(pref.getString(AP_PASSWORD, ""));
		setRememberAP(pref.getBoolean(AP_REMEMBER_ME, false));
	}

	public static synchronized SmartConnectionAP getInstance() {
		if (instance == null) {
			instance = new SmartConnectionAP();
		}
		return instance;
	}


	public void clearPref() {
		setSsid("");
		setPassword("");
		setRememberAP(false);
    saveAP();
	}

	public void saveAP() {
		Editor editor = pref.edit();
		editor.putString(AP_SSID, getSsid());
		editor.putString(AP_PASSWORD, getPassword());
		editor.putBoolean(AP_REMEMBER_ME, isRememberAP());
		editor.commit();
	}

    public String getSsid() {
        return ssid;
    }

    public void setSsid(String ssid) {
        this.ssid = ssid;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isRememberAP() {
        return rememberAP;
    }

    public void setRememberAP(boolean rememberAP) {
        this.rememberAP = rememberAP;
    }
}
