package com.mediatek.mcs.push;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.R;
import com.mediatek.mcs.Utils.UIUtils;
import com.mediatek.mcs.domain.McsPushInstallation;
import com.mediatek.mcs.exception.SdkInstallationException;
import java.io.IOException;

public class PushRegistration {
  private String GCM_SENDER_ID = "";
  private String GCM_API_KEY = "";

  Context context;
  GoogleCloudMessaging gcm;
  String mRegId;

  public PushRegistration(String gcm_sender_id, String gcm_api_key)
      throws SdkInstallationException {

    this.context = Mcs.getApplicationContext();
    this.GCM_SENDER_ID = gcm_sender_id;
    this.GCM_API_KEY = gcm_api_key;

    if (!isPushInstalled(GCM_SENDER_ID, GCM_API_KEY)) return ;

    gcm = GoogleCloudMessaging.getInstance(context);
    mRegId = GcmPreference.getInstance().getRegistrationId(context);

    if (TextUtils.isEmpty(mRegId)) {
      registerInBackground();
    } else {
      setupGcmInstallation();
    }
  }

  /**
   * You should take care isGooglePlayServicesAvailable in your SignIn activity.
   * You could use PlayServicesUtils.isGooglePlayServicesAvailable(Activity);
   */
  public static boolean isPushInstalled(String gcm_sender_id, String gcm_api_key)
      throws SdkInstallationException {
    int playServiceResult = GoogleApiAvailability.getInstance()
        .isGooglePlayServicesAvailable(Mcs.getApplicationContext());
    if (playServiceResult != ConnectionResult.SUCCESS) {
      McsLog.e(Mcs.getApplicationContext().getString(R.string.error_install_no_google_play)
          + "\nplayServiceResult errorCode: " + playServiceResult);
    }

    if (TextUtils.isEmpty(gcm_sender_id) || TextUtils.isEmpty(gcm_api_key)) {
      throw new SdkInstallationException(R.string.error_install_push_gcm_invalid);
    }

    return true;
  }

  private void registerInBackground() {
    new AsyncTask<Void, Void, String>() {
      @Override protected String doInBackground(Void... params) {
        String msg = "";
        try {
          if (gcm == null) {
            gcm = GoogleCloudMessaging.getInstance(context);
          }
          mRegId = gcm.register(GCM_SENDER_ID);
          msg = "Device registered, registration ID = " + mRegId;

          GcmPreference.getInstance().storeRegistrationId(context, mRegId);
          setupGcmInstallation();
        } catch (IOException ex) {
          msg = "Failed to Register GCM. Error :" + ex.getMessage();
          McsLog.e(msg);
        }
        McsLog.d("GCM register msg: " + msg);
        return msg;
      }
    }.execute(null, null, null);
  }

  void setupGcmInstallation() {
    McsPushInstallation.getInstance().setup(mRegId, GCM_API_KEY);
    McsPushInstallation.getInstance().setIsUpdateRegId(GcmPreference.getInstance().isUpdateRegId());

    McsLog.d("Gcm installed successfully");
  }
}
