package com.mediatek.mcs.push;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.R;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class McsPushBroadcastReceiver extends BroadcastReceiver {
  static final String ACTION_RECEIVE = "com.mediatek.mcs.push.intent.RECEIVE";
  static final String ACTION_OPEN = "com.mediatek.mcs.push.intent.OPEN";
  static final String ACTION_DISMISS = "com.mediatek.mcs.push.intent.DISMISS";

  static final String KEY_PUSH_DATA = "pushData";

  static final String PROPERTY_PUSH_ICON = "com.mediatek.mcs.push.notification_icon";

  static final int NOTIFICATION_ID = 1;

  @Override public void onReceive(Context context, Intent intent) {
    McsLog.d(context.getPackageName() + ": " + intent.getAction());

    if (ACTION_RECEIVE.equals(intent.getAction())) {
      onPushReceive(context, intent);
    } else if (ACTION_OPEN.equals(intent.getAction())) {
      onPushOpen(context, intent);
    } else if (ACTION_DISMISS.equals(intent.getAction())) {
      onPushDismiss(context, intent);
    }
  }

  protected void onPushReceive(Context context, Intent intent) {
    getNotification(context, intent);
  }

  protected void onPushOpen(Context context, Intent intent) {
    Class openActivity = getActivity(context, intent);
    if (openActivity != null) {
      Intent nextIntent = new Intent(context, openActivity);
      nextIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
      context.startActivity(nextIntent);
    }
  }

  protected void onPushDismiss(Context context, Intent intent) {
  }

  protected void getNotification(Context context, Intent intent) {
    this.onMessageReceived(context, parseNotif(intent));
  }

  protected void onMessageReceived(Context context, String message) {

    NotificationManager mNotificationManager =
        (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);

    NotificationCompat.Builder mBuilder =
        new NotificationCompat.Builder(context).setAutoCancel(true)
            .setStyle(new NotificationCompat.BigTextStyle().bigText(message))
            .setWhen(System.currentTimeMillis())
            .setDefaults(Notification.DEFAULT_ALL)
            .setSmallIcon(getSmallIconId(context))
            .setContentTitle(context.getString(context.getApplicationInfo().labelRes))
            .setContentText(message)
            .setContentIntent(PendingIntent.getBroadcast(context, 0, new Intent(ACTION_OPEN), 0))
            .setDeleteIntent(PendingIntent.getBroadcast(context, 0, new Intent(ACTION_DISMISS), 0));

    mNotificationManager.notify(NOTIFICATION_ID, mBuilder.build());
  }

  protected Class<? extends Activity> getActivity(Context context, Intent intent) {
    return PushService.setDefaultPushCallback();
  }

  protected int getSmallIconId(Context context) {
    try {
      ApplicationInfo app = context.getPackageManager()
          .getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
      Bundle bundle = app.metaData;
      return bundle.getInt(PROPERTY_PUSH_ICON);
    } catch (PackageManager.NameNotFoundException e) {
      return R.drawable.default_notif_icon;
    }
  }

  private String parseNotif(Intent intent) {
    try {
      String msg = intent.getBundleExtra(McsPushBroadcastReceiver.KEY_PUSH_DATA).getString("alert");
      return (msg == null) ? "" : URLDecoder.decode(msg, "utf-8");
    } catch (UnsupportedEncodingException e) {
      McsLog.e("generateNotification:" + e.getMessage());
      return "";
    }
  }
}
