package com.mediatek.mcs.net;

import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.R;

public class RequestApi {
  public static final int DEFAULT_LIMIT = 20;
  public static final String URL_QUERY_PAGING = "?limit={limit}&page={page}";
  public static final String URL_QUERY_BY_TIME = "?start={start}&end={end}";
  public static final String URL_QUERY_BY_LIMIT = "?offset={offset}&limit={limit}";

  public static final String POST_LOGIN_TOKEN = getOauthServer() + "/login/thirdparty";
  public static final String POST_ACCESS_TOKEN = getOauthServer() + "/login/thirdparty/refresh";
  public static final String GET_USER_INFO = getOauthServer() + "/token/info";
  public static final String REGISTER_MOBILE = getServer() + "/mobiles";
  public static final String UPDATE_MOBILE = getServer() + "/mobiles/{mobileId}";

  public static final String GET_DEVICE_LIST = getServer() + "/devices" + URL_QUERY_PAGING;
  public static final String GET_DEVICE_BY_ID = getServer() + "/devices/{deviceId}";

  public static final String GET_DATA_POINT =
      getServer() + "/devices/{deviceId}/datachannels/{datachannelId}/datapoints";
  public static final String UPLOAD_DATA_POINT = getServer() + "/devices/{deviceId}/datapoints";

  public static final String REGISTER_DEVICE = getServer() + "/devices";

  public static final String GET_PROTOTYPE_LIST = getServer() + "/products";
  public static final String GET_PROTOTYPE_IMAGE = getServer() + "/products/{productId}/images";
  public static final String GET_DEVICE_NOTIF_GROUP_LIST =
      getServer() + "/devices/{deviceId}/criterions";
  public static final String UPDATE_DEVICE_NOTIF_GROUP =
      getServer() + "/devices/{deviceId}/product/criterions/{criterionId}";
  public static final String GET_DEVICE_FIRMWARE_LIST =
      getServer() + "/devices/{deviceId}/firmwares/candidate";
  public static final String UPDATE_DEVICE_FIRMWARE =
      getServer() + "/devices/{deviceId}/firmwares/{firmwareId}";
  public static final String HISTORICAL_GRAPH_API = getGraphServer()
      + "/graph/{graph}/devices/{deviceId}/devicekey/{deviceKey}/datachannels/{datachannelId}";

  public static String getServer() {
    return Mcs.getApplicationContext().getString(R.string.mcs_server);
  }

  public static String getOauthServer() {
    return Mcs.getApplicationContext().getString(R.string.mcs_auth_server);
  }

  public static String getGraphServer() {
    return Mcs.getApplicationContext().getString(R.string.mcs_res_server);
  }

  public static String getLabsServer() {
    return Mcs.getApplicationContext().getString(R.string.mcs_labs_server);
  }

  public static String getImageServerPrefix() {
    return getImageServerPrefix(300);
  }

  public static String getImageServerPrefix(final int ImageSize) {
    return Mcs.getApplicationContext().getString(R.string.mcs_image_server)
        + ImageSize + "/mtk.linkit/";
  }

  public static String setPaging(String url, int page) {
    return setPaging(url, DEFAULT_LIMIT, page);
  }

  public static String setPaging(String url, int limit, int page) {
    return url
        .replace("{limit}", Integer.toString(limit))
        .replace("{page}", Integer.toString(page));
  }
}
