package com.mediatek.mcs.Utils;

import android.app.Activity;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;

public class PlayServicesUtils {

  public static int REQUEST_PLAY_SERVICE = 1001;

  public static boolean isGooglePlayServicesAvailable(final Activity activity) {
    final int googlePlayServicesCheck = GoogleApiAvailability.getInstance()
        .isGooglePlayServicesAvailable(activity);
    switch (googlePlayServicesCheck) {
      case ConnectionResult.SUCCESS:
        return true;
      case ConnectionResult.SERVICE_DISABLED:
      case ConnectionResult.SERVICE_INVALID:
      case ConnectionResult.SERVICE_MISSING:
      case ConnectionResult.SERVICE_VERSION_UPDATE_REQUIRED:
        GoogleApiAvailability.getInstance().getErrorDialog(
            activity,
            googlePlayServicesCheck,
            REQUEST_PLAY_SERVICE
        ).show();
    }
    return false;
  }

}
