/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.smartconn;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.mediatek.mcs.Mcs;

public class SmartConnectionAP {
    private static SmartConnectionAP instance = null;
    private String ssid;
    private String password;
    private boolean rememberAP;
    private SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences((Context)Mcs.getApplicationContext());
    private static final String AP_SSID = "AP_SSID";
    private static final String AP_PASSWORD = "AP_PASSWORD";
    private static final String AP_REMEMBER_ME = "AP_REMEMBER_ME";

    private SmartConnectionAP() {
        this.setSsid(this.pref.getString(AP_SSID, ""));
        this.setPassword(this.pref.getString(AP_PASSWORD, ""));
        this.setRememberAP(this.pref.getBoolean(AP_REMEMBER_ME, false));
    }

    public static synchronized SmartConnectionAP getInstance() {
        if (instance == null) {
            instance = new SmartConnectionAP();
        }
        return instance;
    }

    public void clearPref() {
        this.setSsid("");
        this.setPassword("");
        this.setRememberAP(false);
        this.saveAP();
    }

    public void saveAP() {
        SharedPreferences.Editor editor = this.pref.edit();
        editor.putString(AP_SSID, this.getSsid());
        editor.putString(AP_PASSWORD, this.getPassword());
        editor.putBoolean(AP_REMEMBER_ME, this.isRememberAP());
        editor.commit();
    }

    public String getSsid() {
        return this.ssid;
    }

    public void setSsid(String ssid) {
        this.ssid = ssid;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isRememberAP() {
        return this.rememberAP;
    }

    public void setRememberAP(boolean rememberAP) {
        this.rememberAP = rememberAP;
    }
}

