/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.net;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkError;
import com.android.volley.NoConnectionError;
import com.android.volley.ParseError;
import com.android.volley.ServerError;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.google.gson.Gson;
import com.mediatek.mcs.R;
import com.mediatek.mcs.entity.api.ApiError;
import com.mediatek.mcs.exception.McsNetworkException;
import com.mediatek.mcs.pref.McsUser;
import java.util.HashMap;
import java.util.Map;

public class RequestUtils {
    public static Map<String, String> putAuthHeader(Map<String, String> params) {
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("Content-Type", "application/json");
        params.put("Authorization", "Bearer " + McsUser.getInstance().getAccessToken());
        return params;
    }

    public static Map<String, String> getSignOutHeader(String accessToken) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Content-Type", "application/json");
        hashMap.put("Authorization", "Bearer " + accessToken);
        return hashMap;
    }

    public static String parseMcsNetworkError(Throwable error) {
        return RequestUtils.parseVolleyError((Exception)((VolleyError)error)).getMessage();
    }

    public static McsNetworkException parseVolleyError(Exception error) {
        if (!(error instanceof VolleyError)) {
            return new McsNetworkException("The error is not a network request", (Throwable)error);
        }
        if (error instanceof NoConnectionError) {
            return new McsNetworkException(R.string.error_network_no_connection, (Throwable)error);
        }
        if (error instanceof TimeoutError) {
            return new McsNetworkException(R.string.error_network, (Throwable)error);
        }
        if (error instanceof ServerError || error instanceof AuthFailureError || error instanceof NetworkError || error instanceof ParseError) {
            return new McsNetworkException(RequestUtils.parseApiError((VolleyError)error), (Throwable)error);
        }
        return new McsNetworkException(error.toString(), (Throwable)error);
    }

    public static String parseApiError(VolleyError error) {
        try {
            ApiError apiError = (ApiError)new Gson().fromJson(new String(error.networkResponse.data), ApiError.class);
            String string2 = apiError.getMessage();
            return "".equals(string2) ? error.toString() : string2;
        }
        catch (Exception exception) {
            return error.toString() + ": " + error.getMessage();
        }
    }
}

